/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.util.SequenceReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class xmlutil {
    private static final int BUFFER_SIZE = 4096;
    public static final String m_defaultXMLHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final String m_defaultXMLHeaderStart = "<?xml version=\"1.0\" encoding=\"";
    public static final String m_defaultXMLHeaderEnd = "\"?>\n";
    private static byte[] m_defaultXMLHeaderStartBytes = null;
    private static byte[] m_defaultXMLHeaderEndBytes = null;
    public static byte[] m_defaultXMLHeaderByte = null;
    static final char[] XML_PROLOG_START;
    static final char[] XML_PARTIAL_DOCTYPE;

    public static String getDefaultXMLHeader() {
        return m_defaultXMLHeader;
    }

    public static byte[] getXMLHeaderBytes(String encoding) throws UnsupportedEncodingException {
        byte[] encodingBytes = encoding.getBytes("UTF-8");
        byte[] headerBytes = new byte[m_defaultXMLHeaderStartBytes.length + encodingBytes.length + m_defaultXMLHeaderEndBytes.length];
        System.arraycopy(m_defaultXMLHeaderStartBytes, 0, headerBytes, 0, m_defaultXMLHeaderStartBytes.length);
        System.arraycopy(encodingBytes, 0, headerBytes, m_defaultXMLHeaderStartBytes.length, encodingBytes.length);
        System.arraycopy(m_defaultXMLHeaderEndBytes, 0, headerBytes, m_defaultXMLHeaderStartBytes.length + encodingBytes.length, m_defaultXMLHeaderEndBytes.length);
        return headerBytes;
    }

    public static String getXML(Node node, boolean suppressDeclaration, boolean pretty) throws IOException {
        if (node == null) {
            return null;
        }
        StringWriter sw = new StringWriter(4096);
        if (pretty) {
            OutputFormat prettyformat = OutputFormat.createPrettyPrint();
            prettyformat.setSuppressDeclaration(suppressDeclaration);
            XMLWriter writer = new XMLWriter((Writer)sw, prettyformat);
            writer.write(node);
            writer.close();
        } else {
            OutputFormat compactformat = new OutputFormat();
            compactformat.setSuppressDeclaration(suppressDeclaration);
            XMLWriter writer = new XMLWriter((Writer)sw, compactformat);
            writer.write(node);
            writer.close();
        }
        return sw.toString();
    }

    public static byte[] getXML(Node node, boolean suppressDeclaration, String encoding, boolean pretty) throws IOException {
        if (node == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        if (pretty) {
            OutputFormat prettyformat = OutputFormat.createPrettyPrint();
            prettyformat.setSuppressDeclaration(suppressDeclaration);
            prettyformat.setEncoding(encoding);
            XMLWriter writer = new XMLWriter((OutputStream)out, prettyformat);
            writer.write(node);
            writer.close();
        } else {
            OutputFormat compactformat = new OutputFormat();
            compactformat.setSuppressDeclaration(suppressDeclaration);
            compactformat.setEncoding(encoding);
            XMLWriter writer = new XMLWriter((OutputStream)out, compactformat);
            writer.write(node);
            writer.close();
        }
        return out.toByteArray();
    }

    public static Reader removeXMLProlog(Reader reader) throws IOException {
        char[] prologStart = new char[XML_PROLOG_START.length];
        int bytesRead = reader.read(prologStart);
        if (bytesRead == -1) {
            return reader;
        }
        if (Arrays.equals(prologStart, XML_PROLOG_START)) {
            char[] prologChar = new char[1];
            bytesRead = reader.read(prologChar);
            while (bytesRead != -1) {
                if (prologChar[0] == '?') {
                    bytesRead = reader.read(prologChar);
                    if (bytesRead == -1 || prologChar[0] != '>') break;
                    break;
                }
                bytesRead = reader.read(prologChar);
            }
            if (bytesRead == -1) {
                return reader;
            }
            StringBuffer copyBuffer = new StringBuffer("");
            char[] aChar = new char[1];
            int lastChar = 32;
            int secondlastChar = 32;
            bytesRead = reader.read(aChar);
            if (bytesRead == -1) {
                return reader;
            }
            copyBuffer.append(aChar);
            boolean comment_inprogress = false;
            boolean pi_inprogress = false;
            boolean doctype_inprogress = false;
            boolean done = false;
            do {
                switch (aChar[0]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '<': {
                        break;
                    }
                    case '!': {
                        if (lastChar != 60) break;
                        char[] doctypetest = new char[2];
                        bytesRead = reader.read(doctypetest);
                        if (bytesRead == -1) {
                            return reader;
                        }
                        copyBuffer.append(doctypetest);
                        if (bytesRead != 2) break;
                        if (doctypetest[0] == 'D' && doctypetest[1] == 'O') {
                            char[] doctypeStart = new char[XML_PARTIAL_DOCTYPE.length];
                            bytesRead = reader.read(doctypeStart);
                            if (bytesRead == -1) {
                                return reader;
                            }
                            if (Arrays.equals(doctypeStart, XML_PARTIAL_DOCTYPE)) {
                                doctype_inprogress = true;
                            }
                        } else if (doctypetest[0] == '-' && doctypetest[1] == '-') {
                            comment_inprogress = true;
                        }
                        secondlastChar = aChar[0];
                        lastChar = doctypetest[0];
                        aChar[0] = doctypetest[1];
                        break;
                    }
                    case '?': {
                        if (lastChar != 60) break;
                        pi_inprogress = true;
                        break;
                    }
                    case '>': {
                        if (doctype_inprogress) {
                            return reader;
                        }
                        if (comment_inprogress && lastChar == 45 && secondlastChar == 45) {
                            comment_inprogress = false;
                            break;
                        }
                        if (!pi_inprogress || lastChar != 63) break;
                        pi_inprogress = false;
                        break;
                    }
                    default: {
                        if (doctype_inprogress || comment_inprogress || pi_inprogress) break;
                        done = true;
                    }
                }
                if (done) continue;
                secondlastChar = lastChar;
                lastChar = aChar[0];
                bytesRead = reader.read(aChar);
                if (bytesRead == -1) {
                    return reader;
                }
                copyBuffer.append(aChar);
            } while (!done);
            return new SequenceReader(new StringReader(copyBuffer.toString()), reader);
        }
        return new SequenceReader(new StringReader(new String(prologStart, 0, bytesRead)), reader);
    }

    public static Reader removeDOCTYPEInProlog(Reader reader) throws IOException {
        if (reader == null) {
            return reader;
        }
        StringBuffer copyBuffer = new StringBuffer("");
        char[] aChar = new char[1];
        int lastChar = 32;
        int secondlastChar = 32;
        int bytesRead = reader.read(aChar);
        if (bytesRead == -1) {
            return reader;
        }
        copyBuffer.append(aChar);
        boolean comment_inprogress = false;
        boolean pi_inprogress = false;
        boolean done = false;
        do {
            switch (aChar[0]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '<': {
                    break;
                }
                case '!': {
                    if (lastChar != 60) break;
                    char[] patternTest = new char[2];
                    bytesRead = xmlutil.readMax(patternTest, 2, reader);
                    if (bytesRead != 2) {
                        if (bytesRead > 0) {
                            copyBuffer.append(patternTest, 0, bytesRead);
                        }
                        return new SequenceReader(new StringReader(copyBuffer.toString()), reader);
                    }
                    copyBuffer.append(patternTest);
                    if (patternTest[0] == 'D' && patternTest[1] == 'O') {
                        char[] doctypeStart = new char[XML_PARTIAL_DOCTYPE.length];
                        bytesRead = xmlutil.readMax(doctypeStart, XML_PARTIAL_DOCTYPE.length, reader);
                        if (bytesRead != XML_PARTIAL_DOCTYPE.length) {
                            if (bytesRead > 0) {
                                copyBuffer.append(doctypeStart, 0, bytesRead);
                            }
                            return new SequenceReader(new StringReader(copyBuffer.toString()), reader);
                        }
                        if (Arrays.equals(doctypeStart, XML_PARTIAL_DOCTYPE)) {
                            int n;
                            copyBuffer.delete(copyBuffer.length() - 4, copyBuffer.length());
                            int brackets = 1;
                            char[] ch = new char[1];
                            while ((n = reader.read(ch, 0, 1)) != -1) {
                                if (ch[0] == '<') {
                                    ++brackets;
                                } else if (ch[0] == '>') {
                                    --brackets;
                                }
                                if (brackets != 0) continue;
                                break;
                            }
                            lastChar = 32;
                            secondlastChar = 32;
                            break;
                        }
                        if (bytesRead > 0) {
                            copyBuffer.append(doctypeStart, 0, bytesRead);
                            done = true;
                        }
                    } else if (patternTest[0] == '-' && patternTest[1] == '-') {
                        comment_inprogress = true;
                    }
                    secondlastChar = aChar[0];
                    lastChar = patternTest[0];
                    aChar[0] = patternTest[1];
                    break;
                }
                case '?': {
                    if (lastChar != 60) break;
                    pi_inprogress = true;
                    break;
                }
                case '>': {
                    if (comment_inprogress && lastChar == 45 && secondlastChar == 45) {
                        comment_inprogress = false;
                        break;
                    }
                    if (!pi_inprogress || lastChar != 63) break;
                    pi_inprogress = false;
                    break;
                }
                default: {
                    if (comment_inprogress || pi_inprogress) break;
                    done = true;
                }
            }
            if (done) continue;
            secondlastChar = lastChar;
            lastChar = aChar[0];
            bytesRead = reader.read(aChar);
            if (bytesRead == -1) {
                return new SequenceReader(new StringReader(copyBuffer.toString()), reader);
            }
            copyBuffer.append(aChar);
        } while (!done);
        return new SequenceReader(new StringReader(copyBuffer.toString()), reader);
    }

    private static int readMax(char[] buf, int max, Reader reader) throws IOException {
        int bytesRead;
        char[] aChar = new char[1];
        int totalRead = 0;
        for (int i = 0; i < max && (bytesRead = reader.read(aChar)) != -1; ++i) {
            buf[i] = aChar[0];
            totalRead += bytesRead;
        }
        return totalRead;
    }

    public static void xmlencode(String value, StringBuffer sbuf) {
        block7: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
    }

    public static void xmlencode(String value, Writer buf) throws IOException {
        block7: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    buf.write("&apos;");
                    continue block7;
                }
                case '<': {
                    buf.write("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.write("&gt;");
                    continue block7;
                }
                case '&': {
                    buf.write("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.write("&quot;");
                    continue block7;
                }
                default: {
                    buf.write(x);
                }
            }
        }
    }

    public static void xmlencode2(String value, StringBuffer sbuf) {
        block6: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block6;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
    }

    public static String xmldecode(String value) {
        StringBuffer sbuf = new StringBuffer(value.length());
        int i = 0;
        while (i < value.length()) {
            char x = value.charAt(i);
            if (x != '&') {
                sbuf.append(x);
                ++i;
                continue;
            }
            if (value.startsWith("&apos;", i)) {
                sbuf.append('\'');
                i += 6;
                continue;
            }
            if (value.startsWith("&lt;", i)) {
                sbuf.append('<');
                i += 4;
                continue;
            }
            if (value.startsWith("&gt;", i)) {
                sbuf.append('>');
                i += 4;
                continue;
            }
            if (value.startsWith("&amp;", i)) {
                sbuf.append('&');
                i += 5;
                continue;
            }
            if (value.startsWith("&quot;", i)) {
                sbuf.append('\"');
                i += 6;
                continue;
            }
            sbuf.append('&');
            ++i;
        }
        return sbuf.toString();
    }

    public static String outEntityReference(String entityRef, char[] ch, int start, int length) {
        if (length <= 1) {
            return entityRef;
        }
        return entityRef + new String(ch, start + 1, length - 1);
    }

    static {
        try {
            m_defaultXMLHeaderByte = m_defaultXMLHeader.getBytes("UTF-8");
            m_defaultXMLHeaderStartBytes = m_defaultXMLHeaderStart.getBytes("UTF-8");
            m_defaultXMLHeaderEndBytes = m_defaultXMLHeaderEnd.getBytes("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        XML_PROLOG_START = new char[]{'<', '?', 'x', 'm', 'l'};
        XML_PARTIAL_DOCTYPE = new char[]{'C', 'T', 'Y', 'P', 'E'};
    }
}

