/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.validation;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSCacheFactory;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.properties.PropertiesManager;
import java.util.HashMap;
import java.util.Map;

public class XTSValidatorFactory
extends AXTSCacheFactory {
    private static final String IDENTIFIER = "ValidatorFactory";
    private static final String PROPERTY_PREFIX = "validation.class.";
    private static final String CACHE_SIZE = "validationcache.size";
    public static final String ATTR_KEY1 = "name";
    private static XTSValidatorFactory m_factory = new XTSValidatorFactory();
    private HashMap m_oValidatorMap = new HashMap();
    private int m_iCacheSize = 25;

    public static XTSValidatorFactory getInstance() {
        return m_factory;
    }

    @Override
    protected int getCacheSize() throws XTSCacheException {
        return this.m_iCacheSize;
    }

    @Override
    protected String getClassName(XTSEnvironment env, Map atts) throws XTSCacheException {
        String key = (String)atts.get(ATTR_KEY1);
        String classname = (String)this.m_oValidatorMap.get(key);
        if (classname == null) {
            Object[] args = new String[]{key};
            throw new XTSCacheException("validatorfactory.undefinedvalidation", args);
        }
        return classname;
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map atts) throws XTSCacheException {
        return (String)atts.get(ATTR_KEY1);
    }

    @Override
    protected void preInitialize_Impl() throws XTSCacheException {
        HashMap propMap;
        String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE);
        if (sCacheSize != null) {
            try {
                this.m_iCacheSize = Integer.parseInt(sCacheSize);
            }
            catch (NumberFormatException e) {
                throw new XTSCacheException("validatorfactory.cacheinitfailed", e);
            }
        }
        if ((propMap = PropertiesManager.getInstance().getPropertiesMap(PROPERTY_PREFIX)).size() > 0) {
            String valClassName = null;
            String valName = null;
            Map.Entry pair2 = null;
            for (Map.Entry pair2 : propMap.entrySet()) {
                valClassName = (String)pair2.getValue();
                valName = ((String)pair2.getKey()).substring(PROPERTY_PREFIX.length());
                this.m_oValidatorMap.put(valName, valClassName);
            }
        }
    }

    @Override
    protected void postInitialize_Impl() throws XTSCacheException {
    }

    @Override
    protected void preTerminate_Impl() throws XTSCacheException {
        this.m_oValidatorMap.clear();
    }

    @Override
    protected void postTerminate_Impl() throws XTSCacheException {
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean isSupported(XTSEnvironment env, Map atts) throws XTSCacheException {
        String key = (String)atts.get(ATTR_KEY1);
        return this.m_oValidatorMap.containsKey(key);
    }
}

