/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.ext;

import com.cognos.xts.ext.NBValue;
import com.cognos.xts.ext.NameValuePairList;
import com.cognos.xts.ext.NullValue;
import com.cognos.xts.ext.PeekableReader;
import com.cognos.xts.ext.RangeValue;
import com.cognos.xts.ext.SimpleValue;
import com.cognos.xts.ext.Value;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;

public class PPFilterToParameter {
    public static String GetParametersFromFilter(String filter) {
        return PPFilterToParameter.GetParametersFromFilter(filter, false);
    }

    public static String GetParametersFromFilter(String filter, boolean printError) {
        NameValuePairList params;
        block3: {
            if (filter == null || filter.length() == 0) {
                return "";
            }
            params = new NameValuePairList();
            PeekableReader reader = new PeekableReader(new StringReader(filter), filter.length());
            try {
                PPFilterToParameter.parseFilter(params, reader);
            }
            catch (Exception e) {
                if (!printError) break block3;
                System.out.println("Exception: " + e.getMessage());
            }
        }
        return params.getXML();
    }

    private static void parseFilter(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 91) {
            throw new IOException("Invalid filter - Missing '['!");
        }
        PPFilterToParameter.parsePredicateList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid filter - Missing ']'!");
        }
    }

    private static void parsePredicateList(NameValuePairList params, PeekableReader reader) throws IOException {
        PPFilterToParameter.parsePredicate(params, reader);
        int c = reader.skipSpacesAndPeek();
        while (c == 44) {
            reader.skipSpacesAndRead();
            PPFilterToParameter.parsePredicate(params, reader);
            c = reader.skipSpacesAndPeek();
        }
    }

    private static void parsePredicate(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c != 91) {
            return;
        }
        c = reader.skipSpacesAndRead();
        PPFilterToParameter.parseANDConditionList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid predicator - Missing ']'!");
        }
    }

    private static void parseANDConditionList(NameValuePairList params, PeekableReader reader) throws IOException {
        PPFilterToParameter.parseANDCondition(params, reader);
        int c = reader.skipSpacesAndPeek();
        while (c == 44) {
            reader.skipSpacesAndRead();
            PPFilterToParameter.parseANDCondition(params, reader);
            c = reader.skipSpacesAndPeek();
        }
    }

    private static void parseANDCondition(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 93) {
            c = reader.skipSpacesAndRead();
            return;
        }
        if (c != 91) {
            PPFilterToParameter.parseNVPair(params, reader);
            return;
        }
        c = reader.skipSpacesAndRead();
        PPFilterToParameter.parseORConditionList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid ANDCondition - Missing ']'!");
        }
    }

    private static void parseORConditionList(NameValuePairList params, PeekableReader reader) throws IOException {
        PPFilterToParameter.parseORCondition(params, reader);
        int c = reader.skipSpacesAndPeek();
        while (c == 44) {
            reader.skipSpacesAndRead();
            PPFilterToParameter.parseORCondition(params, reader);
            c = reader.skipSpacesAndPeek();
        }
    }

    private static void parseORCondition(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 93) {
            c = reader.skipSpacesAndRead();
            return;
        }
        if (c != 91) {
            PPFilterToParameter.parseNVPair(params, reader);
            return;
        }
        c = reader.skipSpacesAndRead();
        PPFilterToParameter.parseANDConditionList(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 93) {
            throw new IOException("Invalid ORCondition - Missing ']'!");
        }
    }

    private static void parseNVPair(NameValuePairList params, PeekableReader reader) throws IOException {
        String name = PPFilterToParameter.parseName(params, reader);
        if (name.length() == 0) {
            throw new IOException("Empty name encountered!");
        }
        int c = reader.skipSpacesAndRead();
        if (c != 61) {
            throw new IOException("Invalid NVPair - Missing '='!");
        }
        Value value = PPFilterToParameter.parseValue(params, reader);
        params.add(name, value);
    }

    private static String parseName(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 34) {
            return PPFilterToParameter.parseText(params, reader);
        }
        return PPFilterToParameter.parseFunction(params, reader);
    }

    private static String parseText(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 34) {
            throw new IOException("Invalid Text - Not start with '\"'!");
        }
        String text = reader.getEnclosedText();
        c = reader.read();
        if (c != 34) {
            throw new IOException("Invalid Text - Not end with '\"'!");
        }
        return text;
    }

    private static String parseFunction(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        while (c != 40) {
            c = reader.read();
            if (c != -1) continue;
            throw new IOException("Invalid Function - Missing '('!");
        }
        String text = PPFilterToParameter.parseText(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 41) {
            throw new IOException("Invalid Text - Not end with ')'!");
        }
        return text;
    }

    private static Value parseValue(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndPeek();
        if (c == 40) {
            return PPFilterToParameter.parseRangeValue(params, reader);
        }
        if (c == 34) {
            return PPFilterToParameter.parseSimpleValue(params, reader);
        }
        c = reader.skipSpacesAndRead();
        if (c == 78) {
            c = reader.read();
            if (c == 66) {
                return new NBValue();
            }
            if (c == 85 && (c = reader.read()) == 76 && (c = reader.read()) == 76) {
                return new NullValue();
            }
        }
        throw new IOException("Invalid Value - Neither NULL nor NB!");
    }

    private static Value parseRangeValue(NameValuePairList params, PeekableReader reader) throws IOException {
        int c = reader.skipSpacesAndRead();
        if (c != 40) {
            throw new IOException("Invalid Range Value - Not start with '('!");
        }
        String start = PPFilterToParameter.parseText(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 44) {
            throw new IOException("Invalid Range Value - Missing ','!");
        }
        String end = PPFilterToParameter.parseText(params, reader);
        c = reader.skipSpacesAndRead();
        if (c != 41) {
            throw new IOException("Invalid Range Value - Not end with ')'!");
        }
        return new RangeValue(start, end);
    }

    private static Value parseSimpleValue(NameValuePairList params, PeekableReader reader) throws IOException {
        String text = PPFilterToParameter.parseText(params, reader);
        return new SimpleValue(text);
    }

    public static void main(String[] args) throws IOException {
        String result = "";
        FileWriter f = new FileWriter("PPFilterToParameterTest.xml");
        f.write("<testRoot>");
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=\"Outdoor Products\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=\"Outdoor Products\"],[\"Product Type\"=\"Golf Equipment\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Time\"=(\"1997-04-01\",\"1997-06-30\")],[\"Product Line\"=\"Outdoor Products\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[TRIM(\"Product Line\")=\"Outdoor Products\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=NULL]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=NB]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[[\"Product Type\"=\"Cooking Equipment\",\"Product Line\"=\"Outdoor Products\"],[\"Product Type\"=\"Tents\",\"Product Line\"=\"Outdoor Products\"],[\"Product Type\"=\"Sleeping Bags\",\"Product Line\"=\"Outdoor Products\"]]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Quote\"=\"I say \"\"Just Do It!\"\"\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Quote\"=\"I say \"\"Just \"\"\"\"Do It!\"\"\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Brackets\"=\"I say [\"\"Just \"\"]\"\"Do It!\"\"\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[[\"SALES_BRANCH.CITY\"=\"London\",\"SALES_BRANCH.REGION\"=NB,\"COUNTRY_MULTILINGUAL.COUNTRY\"=\"United Kingdom\"]],[[\"PRODUCT_TYPE.PRODUCT_TYPE_EN\"=\"Safety\",\"PRODUCT_LINE.PRODUCT_LINE_EN\"=\"Mountaineering Equipment\"]]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Pro <>'&\"\"duct Line\"=\"Outdoor <>'&\"\"Products\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Last Name\"=\"Erikson\",\"Last Name\"=\"Blackbeard\",\"Last Name\"=\"Python\",\"Last Name\"=\"Dude\"],[\"Last Name\"=\"Badger\",\"Last Name\"=\"Tiger\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[[TRIM(\"Dev+Code\")=\"E46\",\"Sales+Series\"=\"3 SERIES\",\"Brand_M\"=\"BM\"]]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"Order+Date\"=(\"2000-01-01\",\"2000-01-31\")],[[\"Product+Type\"=\"Cooking+Gear\",\"Product+Line\"=\"Camping+Equipment\"]]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("  [ [ \"code\"=\"10\", [ \"num\"=\"20\", [ \"num\"=\"30\", \"name\"=\"iwr\" ] ] ] ]  ");
        System.out.println(result);
        f.write(result);
        f.flush();
        result = PPFilterToParameter.GetParametersFromFilter("[[\"a\" = \"111\",\"b\" = (\")\",\"x\"), \"c\" = \"222\"]]");
        System.out.println(result);
        f.write(result);
        f.flush();
        f.write("</testRoot>");
        f.close();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=\"Outdoor Products\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=\"Outdoor Products\"],[\"Product Type\"=\"Golf Equipment\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Time\"=(\"1997-04-01\",\"1997-06-30\")],[\"Product Line\"=\"Outdoor Products\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[TRIM(\"Product Line\")=\"Outdoor Products\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=NULL]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Product Line\"=NB]]");
            PPFilterToParameter.GetParametersFromFilter("[[[\"Product Type\"=\"Cooking Equipment\",\"Product Line\"=\"Outdoor Products\"],[\"Product Type\"=\"Tents\",\"Product Line\"=\"Outdoor Products\"],[\"Product Type\"=\"Sleeping Bags\",\"Product Line\"=\"Outdoor Products\"]]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Quote\"=\"I say \"\"Just Do It!\"\"\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Quote\"=\"I say \"\"Just \"\"\"\"Do It!\"\"\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Brackets\"=\"I say [\"\"Just \"\"]\"\"Do It!\"\"\"]]");
            PPFilterToParameter.GetParametersFromFilter("[]");
            PPFilterToParameter.GetParametersFromFilter("[[[\"SALES_BRANCH.CITY\"=\"London\",\"SALES_BRANCH.REGION\"=NB,\"COUNTRY_MULTILINGUAL.COUNTRY\"=\"United Kingdom\"]],[[\"PRODUCT_TYPE.PRODUCT_TYPE_EN\"=\"Safety\",\"PRODUCT_LINE.PRODUCT_LINE_EN\"=\"Mountaineering Equipment\"]]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Pro <>'&\"\"duct Line\"=\"Outdoor <>'&\"\"Products\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Last Name\"=\"Erikson\",\"Last Name\"=\"Blackbeard\",\"Last Name\"=\"Python\",\"Last Name\"=\"Dude\"],[\"Last Name\"=\"Badger\",\"Last Name\"=\"Tiger\"]]");
            PPFilterToParameter.GetParametersFromFilter("[[[TRIM(\"Dev+Code\")=\"E46\",\"Sales+Series\"=\"3 SERIES\",\"Brand_M\"=\"BM\"]]]");
            PPFilterToParameter.GetParametersFromFilter("[[\"Order+Date\"=(\"2000-01-01\",\"2000-01-31\")],[[\"Product+Type\"=\"Cooking+Gear\",\"Product+Line\"=\"Camping+Equipment\"]]]");
            PPFilterToParameter.GetParametersFromFilter("  [ [ \"code\"=\"10\", [ \"num\"=\"20\", [ \"num\"=\"30\", \"name\"=\"iwr\" ] ] ] ]  ");
            PPFilterToParameter.GetParametersFromFilter("[[\"a\" = \"111\",\"b\" = (\")\",\"x\"), \"c\" = \"222\"]]");
        }
        long end = System.currentTimeMillis();
        System.out.println("Time: " + (end - start));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[]", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[[]", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[[[]][][]]", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[a=\"b\"]]", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[TRIM()= \"b\"", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[TRIM(\"\")=\"b\"", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[TRIM(\"\")=\"b\"]]", true));
        System.out.println(PPFilterToParameter.GetParametersFromFilter("[[\"a\" = (\")\",\"x\", \"3\" = \"3\")]]", true));
    }
}

