/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.ext;

import com.cognos.validator.api.IParameter;
import com.cognos.validator.api.IParameterUpdater;
import java.util.ArrayList;
import java.util.List;

public class ValidatorInputParameters
implements IParameterUpdater {
    private List m_paramList = null;
    private int m_listSize = 0;
    private int m_index = -1;

    public ValidatorInputParameters(int initialSize) {
        this.m_paramList = new ArrayList(initialSize);
        this.m_index = 0;
    }

    public void addParameter(String name, String value) {
        Parameter parm = new Parameter(name, value);
        this.m_paramList.add(parm);
        ++this.m_listSize;
    }

    public String getParameterValue(String name) {
        for (Parameter parm : this.m_paramList) {
            if (!parm.name().equals(name)) continue;
            return parm.m_values[0];
        }
        return "";
    }

    public boolean hasNext() {
        return this.m_index < this.m_listSize;
    }

    public IParameter next() {
        if (this.m_index < this.m_listSize) {
            return (Parameter)this.m_paramList.get(this.m_index++);
        }
        return null;
    }

    public void iterator() {
        this.m_index = 0;
    }

    private class Parameter
    implements IParameter {
        private String m_name = null;
        private String[] m_values = null;

        public Parameter(String name, String value) {
            this.m_name = name;
            this.m_values = new String[1];
            this.m_values[0] = value;
        }

        public String name() {
            return this.m_name;
        }

        public String[] values() {
            return this.m_values;
        }

        public void setValues(String[] values) {
            this.m_values = values;
        }
    }
}

