/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi;

import com.cognos.pogo.util.PogoLogger;

public enum MarkerType {
    REPORT(true),
    DASHBOARD(true),
    CUBE(true),
    SUMMARYON(true),
    SUMMARYOFF(true),
    ADHOC(true),
    CANCEL_SUMMARY_ON(true),
    NONE(false);

    private static final MarkerType[] values;
    private static final PogoLogger log;
    private final boolean isValid;

    private MarkerType(boolean isValid) {
        this.isValid = isValid;
    }

    public static MarkerType safeValueOf(String value) {
        try {
            return MarkerType.valueOf(value.toUpperCase());
        }
        catch (Exception e) {
            log.info("Invalid marker type: " + value, (Throwable)e);
            return NONE;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public static MarkerType valueOf(int type) {
        if (type >= 0 && type < values.length) {
            return values[type];
        }
        log.info(new Object[]{"Invalid marker type: ", type});
        return NONE;
    }

    static {
        values = MarkerType.values();
        log = PogoLogger.getLogger();
    }
}

