/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi;

import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.pogo.zipi.RequestAdapter;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiLogger;
import com.ibm.cognos.pogo.zipi.ZipiReader;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.HttpServletRequestAdapter;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanConfig;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvents;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public class ZipiFactory {
    private static final ZipiConfig zipiConfig = new ZipiMBeanConfig();
    private static Storage zipiStorage = Storage.NULL;
    private static ZipiLogger zipiLogger = ZipiLogger.NULL;
    private static int localProcessID;

    public static ZipiTimer startTimer() {
        return ZipiFactory.getLogger().startTimer();
    }

    public static ZipiTimer startTimer(String action) {
        return ZipiFactory.getLogger().startTimer(action);
    }

    public static ZipiTimer startTimer(HttpServletRequest request) {
        return ZipiFactory.getLogger().startTimer(new HttpServletRequestAdapter(request));
    }

    public static ZipiTimer startTimer(RequestAdapter request) {
        return ZipiFactory.getLogger().startTimer(request);
    }

    public static ZipiTimer startTimer(MessageContext mc) {
        return ZipiFactory.getLogger().startTimer(mc);
    }

    public static ZipiTimer startConnectionTimer() {
        return ZipiFactory.getLogger().startConnectionTimer();
    }

    public static ZipiTimer getCurrentTimer() {
        return ZipiFactory.getLogger().getCurrentTimer();
    }

    public static void initialize() {
        ZipiFactory.initialize(new ZipiWallTime());
    }

    public static void initialize(ZipiWallTime wallTime) {
        localProcessID = MBeanUtils.getLocalProcessId();
        zipiStorage = new ZipiStorage(wallTime);
        zipiStorage.initialize();
        zipiLogger = new ZipiMBeanLogger(zipiStorage);
    }

    public static void reset() {
        zipiStorage.reset();
    }

    public static void fullReset() {
        zipiStorage = Storage.NULL;
        zipiLogger = ZipiLogger.NULL;
        localProcessID = 0;
    }

    public static void dump() {
        zipiStorage.dump();
    }

    private static ZipiLogger getLogger() {
        return ZipiFactory.isLoggingEnabled() ? zipiLogger : ZipiLogger.NULL;
    }

    private static boolean isLoggingEnabled() {
        return ZipiFactory.getConfig().isZipiEnabled();
    }

    public static ZipiConfig getConfig() {
        return zipiConfig;
    }

    @Deprecated
    public static ZipiReader getReader() {
        return zipiStorage;
    }

    public static Storage getStorage() {
        return zipiStorage;
    }

    public static Collection<ZipiMBeanEvents> drainEvents() {
        return zipiStorage.drainEvents();
    }

    public static int getLocalProcessID() {
        return localProcessID;
    }
}

