/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.ibm.cognos.pogo.zipi.impl.EventProtectionPolicy;
import com.ibm.cognos.pogo.zipi.impl.Marker;

public class BulkEventParameters {
    private static final EventProtectionPolicy defaultProtectionPolicy = new EventProtectionPolicy();
    private EventProtectionPolicy protectionPolicy = defaultProtectionPolicy;
    private String step;
    private String action;
    private long startTimeInNanos;
    private long elapsedTimeInNanos;
    private long childrenElapsedTimeInNanos;
    private String threadName;
    private String objectPath;
    private Marker marker;

    public BulkEventParameters(String ... eventParameters) throws ArrayIndexOutOfBoundsException, NumberFormatException {
        this(eventParameters[0], eventParameters[1], Long.valueOf(eventParameters[2]), Long.valueOf(eventParameters[3]), Long.valueOf(eventParameters[4]), eventParameters[5], eventParameters.length > 6 ? eventParameters[6] : null);
    }

    public BulkEventParameters(String step, String action, long startTimeInNanos, long elapsedTimeInNanos, long childrenElapsedTimeInNanos, String threadName, String objectPath) {
        this.step = step;
        this.action = action;
        this.startTimeInNanos = startTimeInNanos;
        this.elapsedTimeInNanos = elapsedTimeInNanos;
        this.childrenElapsedTimeInNanos = childrenElapsedTimeInNanos;
        this.threadName = threadName;
        this.objectPath = objectPath;
        if (Marker.isMarkerAction(action)) {
            this.marker = new Marker(action, objectPath);
        }
    }

    public BulkEventParameters(Marker marker) {
        this.marker = marker;
    }

    void setProtectionPolicy(EventProtectionPolicy protectionPolicy) {
        this.protectionPolicy = protectionPolicy;
    }

    public long getElapsedTimeInNanos() throws NumberFormatException {
        return this.elapsedTimeInNanos;
    }

    public String getStep() {
        return this.step;
    }

    public String getAction() {
        return this.action;
    }

    public long getStartTimeInNanos() throws NumberFormatException {
        return this.startTimeInNanos;
    }

    public long getChildrenElapsedTimeInNanos() throws NumberFormatException {
        return this.childrenElapsedTimeInNanos;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public boolean canBeSaved(int discardThresholdInMillis) {
        return this.hasMarker() || this.protectionPolicy.isAboveDiscardThreshold(this.getElapsedTimeInNanos(), discardThresholdInMillis) && (this.protectionPolicy.isSendingRequestEnabled() || !this.protectionPolicy.discardSendingRequestEvent(this.getAction(), this.getElapsedTimeInNanos(), this.getChildrenElapsedTimeInNanos())) || this.protectionPolicy.canProtect(this.action, this.objectPath);
    }

    public Marker getMarker() {
        return this.marker;
    }

    public boolean hasMarker() {
        return this.marker != null;
    }
}

