/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiDatabaseConfiguration;
import com.ibm.cognos.pogo.zipi.impl.ConnectionFactory;
import com.ibm.cognos.pogo.zipi.impl.wrappers.PreparedStatementWrapper;
import com.ibm.cognos.pogo.zipi.impl.wrappers.StatementListener;
import com.ibm.cognos.pogo.zipi.impl.wrappers.StatementWrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseConnection
implements StatementListener {
    private static final PogoLogger staticLog = PogoLogger.getLogger();
    private final PogoLogger log;
    private final ConnectionFactory sqlConnectionFactory;
    private ZipiDatabaseConfiguration config;
    private Connection sqlConnection;
    private boolean bounceSqlConnection;

    public DatabaseConnection() {
        this(staticLog, new ConnectionFactory());
    }

    public DatabaseConnection(PogoLogger log, ConnectionFactory sqlConnectionFactory) {
        this.log = log;
        this.sqlConnectionFactory = sqlConnectionFactory;
    }

    public void connect(ZipiDatabaseConfiguration config) throws SQLException {
        this.reconfigure(config);
        this.connectToDatabase();
    }

    public void reconfigure(ZipiDatabaseConfiguration config) {
        this.log.debug(new Object[]{"Reconfiguring ZIPI/IPA"});
        this.config = config;
    }

    public void connectToDatabase() throws SQLException {
        if (this.config != null && this.config.getDriver() != null) {
            this.loadJdbcDriver();
            this.log.debug(new Object[]{"creating SQL connection for ZIPI/IPA : " + this.config.getUrl()});
            this.createSqlConnection();
            this.disableAutoCommit();
            this.bounceSqlConnection = false;
        }
    }

    private void loadJdbcDriver() {
        String driver = this.config.getDriver();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            this.log.warn(new Object[]{"No JDBC driver found for ", driver});
        }
    }

    private void createSqlConnection() throws SQLException {
        try {
            this.sqlConnection = this.sqlConnectionFactory.createSqlConnection(this.config);
        }
        catch (SQLException e) {
            this.log.error("Failed to connect to ZIPI/IPA database at 02 " + this.config.getUrl(), (Throwable)e);
            throw e;
        }
    }

    private void disableAutoCommit() throws SQLException {
        try {
            this.getSqlConnection().setAutoCommit(false);
        }
        catch (SQLException e) {
            this.log.warn("Failed to disable auto-commit. Problem accessing the database. Closing SQL connection. ", (Throwable)e);
            this.closeConnection();
            throw e;
        }
    }

    protected Connection getSqlConnection() {
        return this.sqlConnection;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfNotConnected();
        try {
            this.log.debug(new Object[]{"Creating statement"});
            Statement statement = this.getSqlConnection().createStatement(resultSetType, resultSetConcurrency);
            return new StatementWrapper(statement, this);
        }
        catch (SQLException e) {
            this.closeConnection();
            throw e;
        }
    }

    private void throwIfNotConnected() throws SQLException {
        if (!this.isConnected()) {
            throw new SQLException("Not connected to ZIPI database.");
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.throwIfNotConnected();
        try {
            this.log.debug(new Object[]{"Creating prepared statement"});
            PreparedStatement statement = this.getSqlConnection().prepareStatement(sql);
            return new PreparedStatementWrapper(statement, (StatementListener)this);
        }
        catch (SQLException e) {
            this.closeConnection();
            throw e;
        }
    }

    public void closeConnection() {
        if (this.isConnected()) {
            try {
                this.log.debug(new Object[]{"Closing connection"});
                this.getSqlConnection().close();
            }
            catch (Exception e) {
                this.log.warn("Failed to close connection", (Throwable)e);
            }
            finally {
                this.sqlConnection = null;
            }
        }
    }

    public void commitTransactions() throws SQLException {
        if (this.isNotAutoCommiting()) {
            this.getSqlConnection().commit();
        }
    }

    public boolean isConnected() {
        return this.getSqlConnection() != null;
    }

    private boolean isNotAutoCommiting() throws SQLException {
        return this.isConnected() && !this.getSqlConnection().getAutoCommit();
    }

    @Override
    public void handleException(SQLException e) {
        this.log.debug("Detected SQL Exception", (Throwable)e);
        this.bounceSqlConnection = true;
    }

    public void checkConnection() {
        this.log.debug(new Object[]{"Checking connection"});
        if (!this.isConnected()) {
            this.tryToConnectToDatabase();
        } else if (this.bounceSqlConnection) {
            this.bounceSqlConnection();
        }
    }

    private void tryToConnectToDatabase() {
        try {
            this.connectToDatabase();
        }
        catch (SQLException e) {
            this.log.error("Failed to connect to ZIPI/IPA database 03", (Throwable)e);
        }
    }

    private void bounceSqlConnection() {
        this.log.debug(new Object[]{"Bouncing connection"});
        this.closeConnection();
        this.tryToConnectToDatabase();
    }
}

