/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import org.apache.commons.lang.StringUtils;

public class EventProtectionPolicy {
    public static final String WIDGET_ACTION = "cv.";
    public static final String MARKER_ACTION = "marker=";
    private static final String[] PROTECTED_ACTIONS_FOR_SUMMARIES = new String[]{"QUERY", "DETAIL_QUERY", "CHART_RENDER", "RUN_EXECUTION_THREAD", "TaskRunner.run"};
    private final ZipiConfig zipiConfig = ZipiFactory.getConfig();

    public boolean canProtect(String action, String objectPath) {
        return this.hasWidgetName(action) || this.hasMarkerName(action);
    }

    private boolean hasWidgetName(String action) {
        return this.startsWith(action, WIDGET_ACTION);
    }

    private boolean hasMarkerName(String action) {
        return this.startsWith(action, MARKER_ACTION);
    }

    protected boolean startsWith(String action, String str) {
        return action != null && action.startsWith(str);
    }

    public boolean canProtect(String username, String action, String objectPath) {
        return this.hasUsername(username) || this.canProtect(action, objectPath);
    }

    protected boolean hasUsername(String username) {
        return StringUtils.isNotEmpty((String)username);
    }

    public boolean isAboveDiscardThreshold(long elapsedTimeInNanos, int discardThresholdInMillis) {
        return elapsedTimeInNanos >= ZipiWallTime.millisToNanos(discardThresholdInMillis);
    }

    public boolean isBelowDiscardThreshold(long elapsedTimeInNanos, int discardThresholdInMillis) {
        return elapsedTimeInNanos < ZipiWallTime.millisToNanos(discardThresholdInMillis);
    }

    public boolean discardSendingRequestEvent(String action, long elapsedTime, long childrenElapsedTime) {
        return action != null && action.equals("*Sending request") && elapsedTime == childrenElapsedTime;
    }

    public boolean isSendingRequestEnabled() {
        return this.zipiConfig.isSendingRequestEnabled();
    }

    public boolean isProtectedForSummaries(String action) {
        for (String protectedAction : PROTECTED_ACTIONS_FOR_SUMMARIES) {
            if (!protectedAction.equals(action)) continue;
            return true;
        }
        return false;
    }
}

