/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvent;

public class EventTracing {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String DLL_NAME = "zipi_etw.dll";
    private static final String MSG_TRYING_TO_LOAD_DLL = "Trying to load zipi_etw.dll";
    private static final String MSG_COULD_NOT_LOAD_DLL = "Could not load zipi_etw.dll";
    private static boolean isEnabled;

    public void initialize() {
        if (this.isRunningOnWindows()) {
            EventTracing.loadEtwDll();
        }
    }

    private boolean isRunningOnWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    private static void loadEtwDll() {
        log.info(new Object[]{MSG_TRYING_TO_LOAD_DLL});
        try {
            System.loadLibrary(DLL_NAME);
            isEnabled = true;
        }
        catch (SecurityException e) {
            log.warn(MSG_COULD_NOT_LOAD_DLL, (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            log.debug(MSG_COULD_NOT_LOAD_DLL, (Throwable)e);
        }
        isEnabled = false;
    }

    public void handleEventCreated(ZipiID zipiID, ZipiMBeanEvent event) {
        if (isEnabled) {
            this.createEtwStartEvent(zipiID.toString(), event.getStep());
        }
    }

    private native void createEtwStartEvent(String var1, String var2);

    public void handleEventSaved(ZipiID zid, ZipiMBeanEvent event) {
        if (isEnabled) {
            this.createEtwStopEvent(zid.toString(), event.getStep(), event.getElapsedTime(), event.getAction(), event.getObjectPath(), event.getUsername(), event.getPassport());
        }
    }

    private native void createEtwStopEvent(String var1, String var2, long var3, String var5, String var6, String var7, String var8);
}

