/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.BaseRequestAdapter;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanID;
import javax.servlet.http.HttpServletRequest;

public class HttpServletRequestAdapter
extends BaseRequestAdapter {
    private static final PogoLogger log = PogoLogger.getLogger();
    private HttpServletRequest request;

    public HttpServletRequestAdapter(HttpServletRequest servletRequest) {
        this.request = servletRequest;
    }

    @Override
    public String getStep() {
        return this.request.getHeader("zipi.step");
    }

    @Override
    public String getSoapAction() {
        String action = this.request.getHeader("SOAPAction");
        if (action == null || action.isEmpty()) {
            action = this.request.getQueryString();
            action = action != null && !action.isEmpty() ? "executeSOAPCommand:" + action : "executeSOAPCommand";
        }
        return action;
    }

    @Override
    public String getSource() {
        String source = this.request.getHeader("zipi.src");
        if ((source == null || source.isEmpty()) && ((source = this.request.getRequestURI()) == null || source.isEmpty())) {
            source = "IPAUknownSource";
        }
        return source;
    }

    @Override
    public String getSourceService() {
        String sourceService = this.request.getHeader("zipi.src_svc");
        if ((sourceService == null || sourceService.isEmpty()) && ((sourceService = this.request.getPathInfo()) == null || sourceService.isEmpty())) {
            sourceService = "IPAUnknownSourceService";
        }
        return sourceService;
    }

    @Override
    public String getId() {
        return this.request.getHeader("zipi.id");
    }

    @Override
    public ZipiID getZipiID() {
        return new ZipiMBeanID(this.getId(), this.isOnDemandRequested(this.request));
    }

    private boolean isOnDemandRequested(HttpServletRequest request) {
        if (!ZipiFactory.getConfig().isIPAEnabled()) {
            return false;
        }
        try {
            if (request.getQueryString() != null && request.getQueryString().contains("p_ShowPerformanceTags") || request.getHeader("x-ca-ipa") != null) {
                return true;
            }
        }
        catch (Exception e) {
            log.error(new Object[]{e.getLocalizedMessage()});
        }
        return false;
    }
}

