/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.MarkerType;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class Marker
implements Serializable {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final long serialVersionUID = 3309770511240678039L;
    private static final char APOSTROPHE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SEMICOLON = ';';
    private static final char EQUALS = '=';
    private int type;
    private String gesture;
    private String name;
    private String fullName;
    private transient String attributeName;
    private transient int equalsPos;

    public Marker() {
        this(MarkerType.NONE, null, null);
    }

    public Marker(MarkerType type, String name, String fullName) {
        this(type, null, name, fullName);
    }

    public Marker(MarkerType type, String gesture, String name, String fullName) {
        this.type = type.ordinal();
        this.gesture = gesture;
        this.name = name;
        this.fullName = fullName;
    }

    public Marker(String action, String objectPath) {
        try {
            this.parseType(action);
            this.parseAttributes(objectPath);
        }
        catch (Exception e) {
            log.info("Failed to parse [action] or [object path]: [" + action + "], [" + objectPath + "]", (Throwable)e);
            this.type = MarkerType.NONE.ordinal();
        }
    }

    public static boolean isMarkerAction(String action) {
        return action != null && action.startsWith("marker=");
    }

    private void parseType(String action) {
        int pos = action.indexOf(61);
        this.type = MarkerType.safeValueOf(StringUtils.substring((String)action, (int)(pos + 1))).ordinal();
    }

    private void parseAttributes(String objectPath) {
        this.findFirstAttributeName(objectPath);
        if ("gesture".equals(this.attributeName)) {
            this.findGesture(objectPath);
        }
        if ("name".equals(this.attributeName)) {
            this.findName(objectPath);
        }
        if ("fullname".equals(this.attributeName)) {
            this.findFullname(objectPath);
        }
    }

    private void findFirstAttributeName(String objectPath) {
        this.equalsPos = StringUtils.indexOf((String)objectPath, (char)'=');
        this.attributeName = StringUtils.substring((String)objectPath, (int)0, (int)this.equalsPos);
    }

    private void findGesture(String objectPath) {
        int semicolonPos = objectPath.indexOf(59);
        this.gesture = this.getAttributeValue(objectPath, this.equalsPos + 1, semicolonPos, semicolonPos + 1);
    }

    private String getAttributeValue(String objectPath, int valueStart, int valueEnd, int nextNameStart) {
        String attributeValue = StringUtils.substring((String)objectPath, (int)valueStart, (int)valueEnd);
        this.findNextAttributeName(objectPath, nextNameStart);
        return attributeValue;
    }

    private void findNextAttributeName(String objectPath, int nameStart) {
        this.equalsPos = StringUtils.indexOf((String)objectPath, (char)'=', (int)nameStart);
        this.attributeName = StringUtils.substring((String)objectPath, (int)nameStart, (int)this.equalsPos);
    }

    private void findName(String objectPath) {
        char quote = objectPath.charAt(this.equalsPos + 1);
        if (quote == '\'' || quote == '\"') {
            this.findName(objectPath, quote, 2);
        } else {
            this.findName(objectPath, ';', 1);
        }
    }

    protected void findName(String objectPath, char separator, int offset) {
        int separatorPos = StringUtils.indexOf((String)objectPath, (char)separator, (int)(this.equalsPos + offset));
        this.name = this.getAttributeValue(objectPath, this.equalsPos + offset, separatorPos, separatorPos + offset);
    }

    private void findFullname(String objectPath) {
        this.fullName = StringUtils.substring((String)objectPath, (int)(this.equalsPos + 1), (int)objectPath.length());
    }

    public MarkerType getType() {
        return MarkerType.valueOf(this.type);
    }

    public String getGesture() {
        return this.gesture;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return "Marker(type=" + (Object)((Object)this.getType()) + ", gesture=" + this.gesture + ", name=" + this.name + ", fullName=" + this.fullName + ")";
    }
}

