/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ObjectPathSimplifier {
    private static final String TIMESTAMP = "TIMESTAMP";
    private static String pattern = "(\\d)(\\d)(\\d)(\\d)(-)(\\d)(\\d)(-)(\\d)(\\d)(T)(\\d)(\\d)(:)(\\d)(\\d)(:)(\\d)(\\d)(\\.)(\\d)(\\d)(\\d)(Z)";
    private static Pattern p = Pattern.compile(pattern, 34);
    private static final Map<String, String> SIMPLIFIED_NAME_MAP;

    public static String getSimplifiedName(String objectPath) {
        if (objectPath != null && objectPath.length() > 30) {
            String sub = objectPath.substring(0, 10);
            String simplified = SIMPLIFIED_NAME_MAP.get(sub);
            if (simplified != null) {
                return simplified;
            }
            simplified = p.matcher(objectPath).replaceAll(TIMESTAMP);
            return simplified;
        }
        return objectPath;
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("~~/runTime", "~~/runTimeState");
        temp.put("//history[", "//history");
        SIMPLIFIED_NAME_MAP = Collections.unmodifiableMap(temp);
    }
}

