/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.ibm.cognos.pogo.zipi.BaseRequestAdapter;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanID;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;

public class ThreadRequestAdapter
extends BaseRequestAdapter {
    public static final int TIMES_STEP_INC = 100;
    private final String initialStep;
    private final String targetService;
    private final ZipiID zipiID;
    private final String source;

    public ThreadRequestAdapter() {
        ZipiTimer parentTimer = ZipiFactory.getCurrentTimer();
        this.initialStep = ThreadRequestAdapter.getInitialStepForChildThread(parentTimer.getCurrentStep());
        parentTimer.incrementAndGetCurrentStep();
        this.targetService = ZipiStorage.getCurrentService();
        this.zipiID = parentTimer.isActive() ? parentTimer.getZipiID() : new ZipiMBeanID();
        this.source = parentTimer.getSource();
    }

    public static String getInitialStepForChildThread(String step) {
        return String.valueOf(Integer.valueOf(step) * 100);
    }

    @Override
    public String getSoapAction() {
        return "New thread started";
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getStep() {
        return this.initialStep;
    }

    @Override
    public ZipiID getZipiID() {
        ZipiStorage.setCurrentService(this.targetService);
        return this.zipiID;
    }
}

