/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.http.inprocess.LocalServletRequest;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventAdapter;
import com.cognos.pogo.pdk.performance.transaction.PerformanceTransaction;
import com.cognos.pogo.transport.ParamBucket;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.MarkerType;
import com.ibm.cognos.pogo.zipi.ZipiAPI;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.transaction.ConnectionRequestTransaction;
import com.ibm.cognos.pogo.zipi.impl.transaction.HandlerTransaction;
import com.ibm.cognos.pogo.zipi.impl.transaction.HttpRequestTransaction;
import com.ibm.cognos.pogo.zipi.impl.transaction.LocalServletTransaction;
import com.ibm.cognos.pogo.zipi.impl.transaction.RootHandlerTransaction;
import com.ibm.cognos.pogo.zipi.impl.transaction.ServiceTransaction;
import com.ibm.cognos.pogo.zipi.impl.transaction.ServletTransaction;
import com.ibm.cognos.pogo.zipi.impl.transaction.ThreadTransaction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpMethod;

public class ZeroImpactPerformanceIndicator
extends PerformanceEventAdapter {
    private static final PogoLogger log = PogoLogger.getLogger();

    public boolean isEnabled() {
        return ZipiFactory.getConfig().isZipiEnabled();
    }

    public void handleUsername(String username) {
        log.debug(new Object[]{"handleUsername: ", username});
        ZipiFactory.getCurrentTimer().setUsername(username);
    }

    public void handleAsyncContext(MessageContext mc) {
        log.debug(new Object[]{"handleAsyncContext"});
        ZipiFactory.getCurrentTimer().updateAsyncContext(mc);
    }

    public void handleObjectPath(String objectPath) {
        log.debug(new Object[]{"handleObjectPath: ", objectPath});
        ZipiFactory.getCurrentTimer().setObjectPath(objectPath);
    }

    public void handleFormParameters(ParamBucket paramBucket) {
        log.debug(new Object[]{"handleFormParameters"});
        ZipiTimer currentTimer = ZipiFactory.getCurrentTimer();
        if (currentTimer.isActive()) {
            this.addSelectedFormParameters(currentTimer, paramBucket);
        }
    }

    private void addSelectedFormParameters(ZipiTimer zipiTimer, ParamBucket paramBucket) {
        for (String name : ZipiFactory.getConfig().getFormParametersNames()) {
            zipiTimer.addFormParameter(name, paramBucket.getValues(name));
        }
    }

    public void handleProcessInfo(int processID, String processName) {
        log.debug(new Object[]{"handleProcessInfo: pid=", processID, ", name=", processName});
        ZipiTimer currentTimer = ZipiFactory.getCurrentTimer();
        currentTimer.setProcessID(processID);
        currentTimer.setProcessName(processName);
    }

    public void handlePogoResponseSent(HttpServletResponse response) {
        log.debug(new Object[]{"handlePogoResponseSent"});
        this.addStepToResponseHeader(response);
    }

    private void addStepToResponseHeader(HttpServletResponse response) {
        String currentStep = ZipiFactory.getCurrentTimer().getCurrentStep();
        if (currentStep != null && ZipiFactory.getCurrentTimer().getZipiID().shouldLog()) {
            response.addHeader("zipi.step", currentStep);
        }
        log.debug(new Object[]{"addStepToResponseHeader: ", "zipi.step", "=", currentStep});
    }

    public PerformanceTransaction handlePogoHandlerInvoked(Handler handler) {
        log.debug(new Object[]{"handlePogoHandlerInvoked: ", handler});
        return new HandlerTransaction(handler);
    }

    public PerformanceTransaction handlePogoServiceInvoked(String serviceName, MessageContext mc) {
        log.debug(new Object[]{"handlePogoServiceInvoked: ", serviceName});
        return new ServiceTransaction(serviceName, mc);
    }

    public PerformanceTransaction handleServletInvoked(HttpServletRequest request) {
        log.debug(new Object[]{"handleServletInvoked: ", request});
        return new ServletTransaction(request);
    }

    public PerformanceTransaction handleThreadRun(String action) {
        log.debug(new Object[]{"handleThreadRun: ", action});
        return new ThreadTransaction(action);
    }

    public PerformanceTransaction handleLocalServletRequest(LocalServletRequest localRequest) {
        log.debug(new Object[]{"handleLocalServletRequest"});
        return new LocalServletTransaction(localRequest);
    }

    public PerformanceTransaction handleRootHandlerInvoked(MessageContext mc) {
        log.debug(new Object[]{"handleRootHandlerInvoked"});
        return new RootHandlerTransaction(mc);
    }

    public PerformanceTransaction handleHttpRequestSent(HttpMethod httpMethod) {
        log.debug(new Object[]{"handleHttpRequestSent"});
        return new HttpRequestTransaction(httpMethod);
    }

    public PerformanceTransaction handleConnectionRequestInvoked(MessageContext mc) {
        log.debug(new Object[]{"handleConnectionRequestInvoked"});
        return new ConnectionRequestTransaction(mc);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void cancelSummaryMode() {
        log.debug(new Object[]{"cancelSummaryMode"});
        ZipiAPI.createMarker(MarkerType.CANCEL_SUMMARY_ON, "", "", "");
    }
}

