/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.ibm.cognos.pogo.zipi.ZipiDatabaseConfiguration;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.dbservers.DB2Server;
import com.ibm.cognos.pogo.zipi.impl.dbservers.DbServer;
import com.ibm.cognos.pogo.zipi.impl.dbservers.MSSQLServer;
import com.ibm.cognos.pogo.zipi.impl.dbservers.OracleServer;
import com.ibm.cognos.pogo.zipi.impl.tables.ActivityTable;
import com.ibm.cognos.pogo.zipi.impl.tables.AllTableNames;
import com.ibm.cognos.pogo.zipi.impl.tables.BucketsTable;
import com.ibm.cognos.pogo.zipi.impl.tables.CogDatesTable;
import com.ibm.cognos.pogo.zipi.impl.tables.CogTimesTable;
import com.ibm.cognos.pogo.zipi.impl.tables.CubeReqTable;
import com.ibm.cognos.pogo.zipi.impl.tables.LogRecordsTable;
import com.ibm.cognos.pogo.zipi.impl.tables.RecordDetailsTable;
import com.ibm.cognos.pogo.zipi.impl.tables.ReportReqTable;
import com.ibm.cognos.pogo.zipi.impl.tables.ServersTable;
import com.ibm.cognos.pogo.zipi.impl.tables.UsersTable;
import com.ibm.cognos.pogo.zipi.impl.tables.ZipiTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZipiDatabaseTables {
    private static Map<String, ZipiTable> tables = ZipiDatabaseTables.createTableMap();
    private static List<DbServer> dbServers = ZipiDatabaseTables.createDbServers();
    private DbServer dbServer;

    private static Map<String, ZipiTable> createTableMap() {
        if (ZipiFactory.getConfig().isIPAEnabled()) {
            AllTableNames.setIPA();
        }
        tables = new LinkedHashMap<String, ZipiTable>();
        tables.put(BucketsTable.TABLE_NAME, new BucketsTable());
        tables.put(ActivityTable.TABLE_NAME, new ActivityTable());
        tables.put(ServersTable.TABLE_NAME, new ServersTable());
        tables.put(UsersTable.TABLE_NAME, new UsersTable());
        tables.put(CogTimesTable.TABLE_NAME, new CogTimesTable());
        tables.put(CogDatesTable.TABLE_NAME, new CogDatesTable());
        tables.put(RecordDetailsTable.TABLE_NAME, new RecordDetailsTable());
        tables.put(LogRecordsTable.TABLE_NAME, new LogRecordsTable());
        tables.put(ReportReqTable.TABLE_NAME, new ReportReqTable());
        tables.put(CubeReqTable.TABLE_NAME, new CubeReqTable());
        return tables;
    }

    private static ArrayList<DbServer> createDbServers() {
        ArrayList<DbServer> dbServers1 = new ArrayList<DbServer>();
        dbServers1.add(new DB2Server());
        dbServers1.add(new MSSQLServer());
        dbServers1.add(new OracleServer());
        return dbServers1;
    }

    static void addDbServer(DbServer builder) {
        dbServers.add(builder);
    }

    static void removeDbServer(DbServer builder) {
        dbServers.remove(builder);
    }

    public ZipiDatabaseTables(ZipiDatabaseConfiguration config) {
        this.dbServer = this.getDbServerForUrl(config.getUrl());
        for (ZipiTable table : tables.values()) {
            table.setDbServer(this.dbServer);
        }
    }

    private DbServer getDbServerForUrl(String url) {
        for (DbServer server : dbServers) {
            if (!server.isCompatibleWithURL(url)) continue;
            return server;
        }
        return DbServer.NULL;
    }

    public void initializeNextIDs(ZipiDatabase zipiDatabase) throws SQLException {
        for (ZipiTable table : tables.values()) {
            table.readNextID(zipiDatabase);
        }
    }

    public long getNextID(String tableName, String columnId) {
        ZipiTable table = this.getZipiTable(tableName);
        return table != null ? table.getNextID(columnId) : 0L;
    }

    public long getNextID(String tableName) {
        ZipiTable table = this.getZipiTable(tableName);
        return table != null ? table.getNextID() : 0L;
    }

    public ZipiTable getZipiTable(String tableName) {
        return tables.get(tableName);
    }

    public final boolean isConfigured() {
        return this.dbServer.isActive();
    }

    public final String getSqlForListingTables() {
        return this.dbServer.getSqlForListingTables();
    }

    public List<String> getAllTableNames() {
        ArrayList<String> allTableNames = new ArrayList<String>();
        for (String tableName : tables.keySet()) {
            allTableNames.add(tableName);
        }
        return allTableNames;
    }

    public void populateDatabaseTables(ZipiDatabase zipiDatabase, int hours, int years) throws SQLException {
        tables.get(CogTimesTable.TABLE_NAME).populate(zipiDatabase, hours);
        tables.get(CogDatesTable.TABLE_NAME).populate(zipiDatabase, years);
        tables.get(BucketsTable.TABLE_NAME).populate(zipiDatabase, 0);
    }

    public List<String[]> getSqlForCreatingAllTables() {
        ArrayList<String[]> createAllTables = new ArrayList<String[]>();
        for (ZipiTable table : tables.values()) {
            createAllTables.add(table.getCreateTableSql());
        }
        return createAllTables;
    }

    public List<String[]> getSqlForDroppingAllTables() {
        ArrayList<String[]> dropAllTables = new ArrayList<String[]>();
        for (ZipiTable table : this.getTablesInReverseOrder()) {
            dropAllTables.add(table.getDropTableSql());
        }
        return dropAllTables;
    }

    private List<ZipiTable> getTablesInReverseOrder() {
        ArrayList<ZipiTable> tablesInReverse = new ArrayList<ZipiTable>(tables.values());
        Collections.reverse(tablesInReverse);
        return tablesInReverse;
    }
}

