/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.pool.StringPool;
import com.cognos.pogo.util.pool.WeakHashPool;
import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.BulkEventParameters;
import com.ibm.cognos.pogo.zipi.impl.EventProtectionPolicy;
import com.ibm.cognos.pogo.zipi.impl.Marker;
import com.ibm.cognos.pogo.zipi.impl.ObjectPathSimplifier;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Priority;

public class ZipiMBeanEvent
implements ZipiEvent,
Serializable {
    private static final long serialVersionUID = -6226716943977564739L;
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String DEFAULT_INITIAL_STEP = "1";
    public static final String DEFAULT_INITIAL_CATEGORY = "UNCLASSIFIED";
    private static final StringPool stringPool = new WeakHashPool();
    private static final EventProtectionPolicy protectionPolicy = new EventProtectionPolicy();
    private Marker marker;
    private String step;
    private long startNanoTime;
    private long startClockTime;
    private long elapsedNanoTime;
    private long elapsedClockTime;
    private long childrenElapsedTime;
    private String action;
    private String source;
    private String sourceService = "Dispatcher";
    private String targetService;
    private String threadName;
    private String passport;
    private String username;
    private String objectPath;
    private String category = "UNCLASSIFIED";
    private int processID;
    private String processName;
    private Map<String, Vector<String>> formParameters;
    private boolean isProtected;
    private boolean isOnlyEvent = true;
    private boolean shouldDiscard = false;
    private static final Pattern leadingAndTrailingQuotesAndSpaces = Pattern.compile("^['\"\\s]*|['\"\\s]*$");

    public ZipiMBeanEvent() {
        this(DEFAULT_INITIAL_STEP, 0L, 0L);
    }

    public void setShouldDiscard(boolean shouldDiscard) {
        this.shouldDiscard = shouldDiscard;
    }

    @Override
    public boolean shouldDiscard() {
        return this.shouldDiscard;
    }

    public ZipiMBeanEvent(String initialStep, long startNanoTime, long startClockTime) {
        this.setStep(initialStep);
        this.setNanoTime(startNanoTime);
        this.setStartClockTime(startClockTime);
        this.setThreadName(Thread.currentThread().getName());
    }

    public ZipiMBeanEvent(BulkEventParameters bulkEventParameters) {
        this.setBulkEventParameters(bulkEventParameters);
        this.setTargetService(ZipiStorage.getCurrentService());
        this.setProcessID(ZipiFactory.getCurrentTimer().getProcessID());
    }

    public void setBulkEventParameters(BulkEventParameters bulkEventParameters) {
        this.setMarker(bulkEventParameters.getMarker());
        this.setStep(bulkEventParameters.getStep());
        this.setNanoTime(bulkEventParameters.getStartTimeInNanos());
        this.setAction(bulkEventParameters.getAction());
        this.setElapsedTime(bulkEventParameters.getElapsedTimeInNanos());
        this.setChildrenElapsedTime(bulkEventParameters.getChildrenElapsedTimeInNanos());
        this.setThreadName(bulkEventParameters.getThreadName());
        this.setNonEmptyObjectPath(bulkEventParameters.getObjectPath());
        this.assumeBulkEventsComeInPack();
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    private void setMarker(Marker marker) {
        this.marker = marker;
    }

    @Override
    public boolean isMarkerEvent() {
        return this.marker != null && this.marker.getType().isValid();
    }

    private void assumeBulkEventsComeInPack() {
        this.isOnlyEvent = false;
    }

    @Override
    public long getStartTime() {
        return this.startNanoTime;
    }

    private void setNanoTime(long startNanoTime) {
        this.startNanoTime = startNanoTime;
    }

    @Override
    public long getStartClockTime() {
        return this.startClockTime;
    }

    private void setStartClockTime(long startClockTime) {
        this.startClockTime = startClockTime;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedNanoTime;
    }

    public void setElapsedTime(long elapsedNanoTime) {
        this.elapsedNanoTime = elapsedNanoTime;
    }

    @Override
    public long getElapsedClockTime() {
        return this.elapsedClockTime;
    }

    public void setElapsedClockTime(long elapsedClockTime) {
        this.elapsedClockTime = elapsedClockTime;
    }

    @Override
    public long getChildrenElapsedTime() {
        return this.childrenElapsedTime;
    }

    public void setChildrenElapsedTime(long childrenElapsedTime) {
        this.childrenElapsedTime = childrenElapsedTime;
    }

    public void handleChildEvent(ZipiEvent event) {
        this.childrenElapsedTime += event.getElapsedTime();
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void stop(long stopNanoTime, long stopClockTime) {
        this.setElapsedTime(stopNanoTime - this.startNanoTime);
        this.setElapsedClockTime(stopClockTime - this.startClockTime);
        log.debug(new Object[]{"stop: elapsedNanoTime=", this.elapsedNanoTime, ", elapsedClockTime=", this.elapsedClockTime, ", childrenElapsedTime=", this.childrenElapsedTime, ", threadName=", this.threadName, ", hash: ", this.hashCode()});
    }

    public void dump(String indent) {
        log.debug(new Object[]{indent, this});
    }

    public String toString() {
        return "ZipiMBeanEvent(hash=" + this.hashCode() + " startNanoTime=" + this.startNanoTime + ", elapsedNanoTime=" + this.elapsedNanoTime + " startClockTime=" + this.startClockTime + ", elapsedClockTime=" + this.elapsedClockTime + ", action=" + this.action + ", src=" + this.source + ", sourceService=" + this.sourceService + ", targetService=" + this.targetService + ", step=" + this.step + ", thread=" + this.threadName + ", passport=" + this.passport + ", username=" + this.username + ", objectPath=" + this.objectPath + ", processID=" + this.processID + ", processName=" + this.processName + ", marker=" + this.marker + ")";
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        log.debug(new Object[]{"raw action=", action, ", hash: ", this.hashCode()});
        this.action = this.cleanupActionString(action);
        this.updateProtection();
    }

    protected String cleanupActionString(String action) {
        if (StringUtils.isNotEmpty((String)action)) {
            action = leadingAndTrailingQuotesAndSpaces.matcher(action).replaceAll("");
        }
        return this.intern(action);
    }

    protected String intern(String s) {
        return stringPool.intern(s);
    }

    private void updateProtection() {
        this.isProtected = protectionPolicy.canProtect(this.username, this.action, this.objectPath);
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        log.debug(new Object[]{"source=", source, ", hash: ", this.hashCode()});
        this.source = this.intern(source);
    }

    @Override
    public String getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(String sourceService) {
        log.debug(new Object[]{"sourceService=", sourceService, ", hash: ", this.hashCode()});
        this.sourceService = this.intern(sourceService);
    }

    @Override
    public String getTargetService() {
        return this.targetService;
    }

    public void setTargetService(String targetService) {
        log.debug(new Object[]{"targetService=", targetService, ", hash: ", this.hashCode()});
        this.targetService = this.intern(targetService);
    }

    @Override
    public String getStep() {
        return this.step;
    }

    private void setStep(String initialStep) {
        this.step = StringUtils.isEmpty((String)initialStep) ? DEFAULT_INITIAL_STEP : this.intern(initialStep);
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public String getPassport() {
        return this.passport;
    }

    public void setPassport(String passport) {
        log.debug(new Object[]{"passport=", passport, ", hash: ", this.hashCode()});
        this.passport = this.intern(passport);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        log.debug(new Object[]{"username=", username, ", hash: ", this.hashCode()});
        this.username = this.intern(username);
        this.updateProtection();
    }

    @Override
    public String getObjectPath() {
        return StringUtils.isNotEmpty((String)this.objectPath) ? this.objectPath : this.getFormParameters();
    }

    public void setObjectPath(String objectPath) {
        log.debug(new Object[]{"objectPath=", objectPath, ", hash: ", this.hashCode()});
        objectPath = ObjectPathSimplifier.getSimplifiedName(objectPath);
        this.objectPath = this.intern(objectPath);
        this.updateProtection();
    }

    private void setNonEmptyObjectPath(String objectPath) {
        if (StringUtils.isNotBlank((String)objectPath)) {
            this.setObjectPath(objectPath);
        }
    }

    public void addFormParameter(String name, Vector<String> values) {
        this.createFormParametersIfNeeded();
        this.formParameters.put(this.intern(name), values);
    }

    private void createFormParametersIfNeeded() {
        if (this.formParameters == null) {
            this.formParameters = new HashMap<String, Vector<String>>();
        }
    }

    private String getFormParameters() {
        if (this.formParameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Vector<String>> entry : this.formParameters.entrySet()) {
            this.appendFormParameter(sb, entry);
        }
        return sb.toString();
    }

    private void appendFormParameter(StringBuilder sb, Map.Entry<String, Vector<String>> entry) {
        Vector<String> values = entry.getValue();
        if (values != null) {
            for (String value : values) {
                this.appendNameValue(sb, entry.getKey(), value);
            }
        }
    }

    private void appendNameValue(StringBuilder sb, String name, String value) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(name).append('=').append(value);
    }

    @Override
    public int getProcessID() {
        return this.processID;
    }

    public void setProcessID(int processID) {
        log.debug(new Object[]{"processID=", processID, ", hash: ", this.hashCode()});
        this.processID = processID;
    }

    @Override
    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        log.debug(new Object[]{"processName=", processName, ", hash: ", this.hashCode()});
        this.processName = this.intern(processName);
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String cat) {
        log.debug(new Object[]{"category=", this.category, ", hash: ", this.hashCode()});
        this.category = cat;
    }

    public void handleSubsequentEventCreated() {
        this.isOnlyEvent = false;
    }

    @Override
    public boolean canBeDiscarded(int discardThresholdInMillis) {
        return this.isDiscardable() && protectionPolicy.isBelowDiscardThreshold(this.getElapsedTime(), discardThresholdInMillis);
    }

    @Override
    public boolean canBeRemovedFromSummary() {
        return this.isDiscardable() && !protectionPolicy.isProtectedForSummaries(this.getAction());
    }

    @Override
    public boolean canBeSaved(int discardThresholdInMillis) {
        return this.isProtected() || this.isFirstStep() || protectionPolicy.isAboveDiscardThreshold(this.getElapsedTime(), discardThresholdInMillis) && (protectionPolicy.isSendingRequestEnabled() || !this.shouldDiscard());
    }

    public boolean isDiscardable() {
        if (this.isProtected()) {
            return false;
        }
        if (this.isFirstStep()) {
            return this.isOnlyEvent;
        }
        return true;
    }

    private boolean isFirstStep() {
        return DEFAULT_INITIAL_STEP.equals(this.getStep());
    }
}

