/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.ibm.cognos.pogo.zipi.MarkerType;
import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.ZipiEvents;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.impl.Marker;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ZipiMBeanEvents
implements ZipiEvents,
Serializable {
    private static final long serialVersionUID = -2947327805937800195L;
    private static final int UNDEFINED = 0;
    private static final int VERBOSE = 1;
    private static final int SUMMARY = 2;
    private final List<ZipiEvent> events = Collections.synchronizedList(new ArrayList());
    private final ZipiID zid;
    private int threshold;
    private int summaryState;

    public ZipiMBeanEvents(ZipiID zid) {
        this.zid = zid;
        this.threshold = ZipiFactory.getConfig().getDiscardThresholdInMillis();
    }

    @Override
    public ZipiID getZipiID() {
        return this.zid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ZipiEvent> iterator() {
        List<ZipiEvent> list = this.events;
        synchronized (list) {
            return new ArrayList<ZipiEvent>(this.events).iterator();
        }
    }

    public boolean add(ZipiEvent event) {
        if (this.isNull(event)) {
            return false;
        }
        this.checkForSummaryEvent(event);
        return this.events.add(event);
    }

    protected boolean isNull(ZipiEvent event) {
        return event == null || event == ZipiEvent.NULL;
    }

    private void checkForSummaryEvent(ZipiEvent event) {
        if (this.summaryState != 1) {
            this.checkForSummaryMarker(this.getMarkerType(event));
        }
    }

    protected void checkForSummaryMarker(MarkerType markerType) {
        if (markerType == MarkerType.SUMMARYON) {
            this.summaryState = 2;
        }
        if (markerType == MarkerType.SUMMARYOFF) {
            this.summaryState = 1;
        }
        if (markerType == MarkerType.CANCEL_SUMMARY_ON) {
            this.summaryState = 0;
        }
    }

    private MarkerType getMarkerType(ZipiEvent event) {
        Marker marker = event.getMarker();
        return marker != null ? marker.getType() : MarkerType.NONE;
    }

    public void dump(String indent) {
        indent = indent + "   ";
        for (ZipiEvent event : this.events) {
            ((ZipiMBeanEvent)event).dump(indent);
        }
    }

    public void dump() {
        this.dump("");
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    public int size() {
        return this.events.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discardEvents(int discardThresholdInMillis) {
        List<ZipiEvent> list = this.events;
        synchronized (list) {
            int initialSize = this.events.size();
            Iterator<ZipiEvent> it = this.events.iterator();
            while (it.hasNext()) {
                if (!it.next().canBeDiscarded(discardThresholdInMillis)) continue;
                it.remove();
            }
            return initialSize - this.events.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardNonSummaryEvents() {
        List<ZipiEvent> list = this.events;
        synchronized (list) {
            Iterator<ZipiEvent> it = this.events.iterator();
            while (it.hasNext()) {
                if (!it.next().canBeRemovedFromSummary()) continue;
                it.remove();
            }
        }
    }

    public boolean isSummary() {
        return this.summaryState == 2;
    }
}

