/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.NullFactory;
import com.ibm.cognos.pogo.zipi.RequestAdapter;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ThreadContext;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.ZipiLogger;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.MessageContextRequestAdapter;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanTimer;
import org.apache.log.Priority;

public class ZipiMBeanLogger
implements ZipiLogger {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final Storage zipiStorage;

    public ZipiMBeanLogger(Storage zipStorage) {
        this.zipiStorage = zipStorage;
    }

    @Override
    public ZipiMBeanTimer startTimer() {
        ThreadContext context = this.zipiStorage.getOrCreateContext();
        log.debug(new Object[]{"startTimer(): ", context});
        return this.startTimer(context);
    }

    @Override
    public ZipiTimer startTimer(String action) {
        ZipiMBeanTimer zipiTimer = this.startTimer();
        zipiTimer.setAction(action);
        return zipiTimer;
    }

    private ZipiMBeanTimer startTimer(ThreadContext context) {
        if (context.getZipiId().shouldLog() || !ZipiFactory.getConfig().isIPAEnabled() && ZipiFactory.getConfig().isZipiInternalEnabled()) {
            String step = context.incrementAndGetCurrentStep();
            log.debug(new Object[]{"startTimer(context): ", context, ", step=", step});
            return new ZipiMBeanTimer(this, context, step);
        }
        return (ZipiMBeanTimer)NullFactory.NULL_TIMER;
    }

    @Override
    public ZipiTimer startTimer(RequestAdapter request) {
        boolean isZipiInternalEnabled = ZipiFactory.getConfig().isZipiInternalEnabled();
        if (request.getZipiID() != null && request.getZipiID().shouldLog() || !ZipiFactory.getConfig().isIPAEnabled() && isZipiInternalEnabled) {
            ThreadContext context = this.zipiStorage.getContext(request.getZipiID());
            log.debug(new Object[]{"zipi saved : " + request.getZipiID().shouldLog() + "," + ZipiFactory.getConfig().isIPAEnabled() + "," + isZipiInternalEnabled});
            log.debug(new Object[]{"startTimer(request): ", context, ", ", request});
            return new ZipiMBeanTimer(this, context, request);
        }
        return NullFactory.NULL_TIMER;
    }

    @Override
    public ZipiTimer startTimer(MessageContext mc) {
        MessageContextRequestAdapter adapter = new MessageContextRequestAdapter(mc);
        boolean shouldAddZipiToMessageContext = adapter.getZipiID() == null;
        ZipiTimer timer = this.startTimer(adapter);
        if (shouldAddZipiToMessageContext) {
            this.addZipiToMessageContext(mc, timer);
        }
        return timer;
    }

    private void addZipiToMessageContext(MessageContext mc, ZipiTimer timer) {
        if (timer.getZipiID().shouldLog()) {
            mc.setProperty("zipi.step", (Object)timer.getCurrentStep());
            mc.setProperty("zipi.id", (Object)timer.getZipiID());
        }
    }

    @Override
    public ZipiTimer startConnectionTimer() {
        ZipiMBeanTimer connectionTimer = this.startTimer();
        connectionTimer.setAction("*Sending request");
        return connectionTimer;
    }

    @Override
    public ZipiTimer getCurrentTimer() {
        ThreadContext currentContext = this.zipiStorage.getCurrentContext();
        return currentContext.getTimer();
    }

    @Override
    public ZipiID getZipiID() {
        ThreadContext context = this.zipiStorage.getOrCreateContext();
        return context.getZipiId();
    }

    public Storage getStorage() {
        return this.zipiStorage;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

