/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.StringsEnvelope;
import com.cognos.pogo.pdk.common.DispatcherTransportVars;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanID;

public class ZipiResponseFilter {
    private static final PogoLogger log = PogoLogger.getLogger();

    public void handleResponse(MessageContext mc) {
        if (ZipiFactory.getConfig().isZipiEnabled()) {
            this.tryToInterceptZipiOutput(mc);
        }
    }

    private void tryToInterceptZipiOutput(MessageContext mc) {
        try {
            this.interceptZipiOutput(mc);
        }
        catch (Exception e) {
            log.warn("Cannot retrieve ZIPI output", (Throwable)e);
        }
    }

    private void interceptZipiOutput(MessageContext mc) throws Exception {
        Envelope response = (Envelope)mc.getProperty("response.envelope");
        if (this.hasZipiInfo(response)) {
            this.createZipiEvents(response);
        }
    }

    private boolean hasZipiInfo(Envelope response) {
        return response != null && !(response instanceof StringsEnvelope);
    }

    protected void createZipiEvents(Envelope response) {
        log.debug(new Object[]{"Checking for ZIPI events in the response header: ", response});
        String zipiOutput = this.removeZipiOutput(response);
        if (zipiOutput != null) {
            this.tryToParse(zipiOutput);
        }
    }

    private String removeZipiOutput(Envelope response) {
        String zipiOutput = this.removeDispatcherTransportVar(response, "zipiOutput");
        return XmlUtils.xmlDecode((String)zipiOutput);
    }

    private String removeDispatcherTransportVar(Envelope response, String name) {
        DispatcherTransportVars dispatcherTransportVars = response.getBiBusHeader().getDispatcherTransportVars();
        String value = dispatcherTransportVars.getValue(name);
        dispatcherTransportVars.removeValue(name);
        return value;
    }

    private void tryToParse(String zipiOutput) {
        log.debug(new Object[]{"Attempting to parse ZIPI output: ", zipiOutput});
        try {
            this.parseZipiReport(zipiOutput);
        }
        catch (Exception e) {
            log.warn("Invalid ZIPI output received: " + zipiOutput, (Throwable)e);
        }
    }

    private void parseZipiReport(String zipiOutput) throws Exception {
        ZipiID currentZipiID = ZipiFactory.getCurrentTimer().getZipiID();
        for (String line : zipiOutput.split("\n")) {
            if (this.hasZipiID(line)) {
                currentZipiID = this.extractZipiID(line);
                continue;
            }
            this.getZipiStorage().createBulkEvent(currentZipiID, line.split("\t"));
        }
    }

    private boolean hasZipiID(String line) {
        return line.startsWith("[");
    }

    private ZipiID extractZipiID(String line) {
        String zipiID = line.substring(1, line.indexOf(93));
        return new ZipiMBeanID(zipiID);
    }

    private Storage getZipiStorage() {
        return ZipiFactory.getStorage();
    }
}

