/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.NullZipiStats;

public class ZipiStats {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final ZipiStats NULL = new NullZipiStats();
    private final ZipiStats totalStats;
    private final String serverName;
    private long collectionCount;
    private long startTime;
    private long elapsedTime;
    private int eventCount;

    public ZipiStats(String serverName) {
        this(serverName, NULL);
    }

    public ZipiStats(String serverName, ZipiStats totalStats) {
        this.serverName = serverName;
        this.totalStats = totalStats;
    }

    public void collectionStarted() {
        ++this.collectionCount;
        this.startTime = System.currentTimeMillis();
        this.elapsedTime = 0L;
        this.totalStats.collectionStarted();
    }

    public void collectionEnded() {
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        this.totalStats.collectionEnded();
    }

    public void collectionEnded(int eventCount) {
        this.eventCount = eventCount;
        this.collectionEnded();
        this.totalStats.collectionEnded(eventCount);
    }

    public long getCollectionCount() {
        return this.collectionCount;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void writeToLog() {
        if (log.isInfoEnabled()) {
            log.info(new Object[]{this.serverName, ": Collection #", this.collectionCount, " took ", this.elapsedTime, " ms", this.getEventCountLog()});
        }
    }

    private String getEventCountLog() {
        return this.eventCount > 0 ? " and recorded " + this.eventCount + " event sets" : "";
    }
}

