/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.TimerFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;

public class ZipiStorageMonitor
implements PogoTimerOwner {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final TimerFactory timerFactory;
    private final ZipiConfig zipiConfig;
    private Storage zipiStorage;
    private PogoTimer monitorTimer;
    private long monitoringIntervalInMillis;

    public ZipiStorageMonitor() {
        this(ZipiFactory.getConfig(), new TimerFactory());
    }

    public ZipiStorageMonitor(ZipiConfig zipiConfig, TimerFactory timerFactory) {
        this.zipiConfig = zipiConfig;
        this.timerFactory = timerFactory;
    }

    public void start(Storage zipiStorage) {
        log.info(new Object[]{"Starting storage monitor"});
        this.zipiStorage = zipiStorage;
        this.monitoringIntervalInMillis = this.getMonitoringIntervalInMillis();
        this.monitorTimer = this.timerFactory.createPeriodicTimer(this, this.monitoringIntervalInMillis);
    }

    public void stop() {
        this.monitorTimer.cancel();
    }

    private long getMonitoringIntervalInMillis() {
        return ZipiWallTime.secsToMillis(this.zipiConfig.getCollectionTimeoutInSecs());
    }

    public void handleTimeoutEvent(Object parameter) throws Exception {
        log.debug(new Object[]{"Running storage monitor"});
        if (this.needsToIncreaseDiscardThreshold()) {
            this.increaseDiscard();
        } else {
            this.decreaseDiscard();
        }
    }

    protected boolean needsToIncreaseDiscardThreshold() {
        if (this.zipiStorage.isEmpty()) {
            return false;
        }
        return this.zipiStorage.hasCollectionTimedOut() || this.wasMaxEventReached();
    }

    private void increaseDiscard() {
        this.zipiConfig.increaseDiscardThreshold();
        if (this.wasMaxEventReached()) {
            this.zipiStorage.discardShortEvents();
        }
    }

    private boolean wasMaxEventReached() {
        return this.zipiStorage.getCurrentNumberOfEvents() >= this.zipiConfig.getMaxEventsAllowed();
    }

    private void decreaseDiscard() {
        this.zipiConfig.decreaseDiscardThreshold();
    }

    public void handleMaxEventsReached() {
        log.debug(new Object[]{"Max events reached"});
        this.timerFactory.createSingleExecutionTimer(this, 0);
    }
}

