/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiAPI;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public abstract class BatchPreparedStatement {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final int MAX_BATCH_COUNT = 1000;
    private ZipiDatabase zipidb;
    private int batchCount;
    private int totalBatchCount;
    private PreparedStatement ps;
    private StringBuilder preparedStatementValues;
    private ArrayList<String> preparedStatementList;
    private String sql;
    private ArrayList<LookupBatchPreparedStatement> lookupBatchps;

    public BatchPreparedStatement(ZipiDatabase zipidb, String sql) throws SQLException {
        this.zipidb = zipidb;
        this.sql = sql;
        this.ps = zipidb.prepareStatement(sql);
        this.lookupBatchps = new ArrayList();
        this.debugInitialize();
    }

    public void addLookupBatchPreparedStatement(LookupBatchPreparedStatement ps) {
        this.lookupBatchps.add(ps);
    }

    public boolean hasBatch() {
        return this.batchCount != 0;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public int getTotalBatchCount() {
        return this.totalBatchCount;
    }

    public void addBatch() throws SQLException {
        this.ps.addBatch();
        ++this.batchCount;
        ++this.totalBatchCount;
        this.debugAddSingleBatchToLog();
        if (this.batchCount == 1000) {
            this.preExecuteBatch();
            this.executeBatch();
        }
    }

    protected void executeBatch() throws SQLException {
        ZipiTimer timer = ZipiAPI.startTimer("ZIPI.executeBatch");
        timer.setObjectPath(this.sql);
        try {
            this.zipidb.executeBatchSQL(this.ps);
        }
        catch (SQLException e) {
            this.debugWriteLogs();
            throw e;
        }
        finally {
            this.batchCount = 0;
            timer.stop();
        }
    }

    private void preExecuteBatch() throws SQLException {
        for (LookupBatchPreparedStatement ps : this.lookupBatchps) {
            if (!ps.hasBatch()) continue;
            ps.executeBatch();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushBatch() throws SQLException {
        block4: {
            try {
                if (this.hasBatch()) {
                    log.info(new Object[]{"PreparedStatement SQL: ", this.sql});
                    this.executeBatch();
                }
                if (this.totalBatchCount == 0) break block4;
            }
            catch (Throwable throwable) {
                if (this.totalBatchCount != 0) {
                    log.info(new Object[]{"Total batched entries processed: ", this.totalBatchCount});
                }
                this.totalBatchCount = 0;
                this.closePreparedStatement();
                throw throwable;
            }
            log.info(new Object[]{"Total batched entries processed: ", this.totalBatchCount});
        }
        this.totalBatchCount = 0;
        this.closePreparedStatement();
    }

    private void closePreparedStatement() {
        try {
            this.ps.close();
        }
        catch (SQLException e) {
            log.warn("Following exception occurred while closing prepared statement: ", (Throwable)e);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.logPSValue(parameterIndex, x);
        this.ps.setBoolean(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.logPSValue(parameterIndex, x);
        this.ps.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.logPSValue(parameterIndex, x);
        this.ps.setLong(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.logPSValue(parameterIndex, x);
        this.ps.setString(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int type) throws SQLException {
        this.logNullPSValue(parameterIndex, type);
        this.ps.setNull(parameterIndex, type);
    }

    protected void setStringIndex(int paramIndex, String value) throws SQLException {
        if (value != null) {
            this.setString(paramIndex, value);
        } else {
            this.setNull(paramIndex, 12);
        }
    }

    protected void setTimestamp(int timestampColumnIndex, Timestamp timestamp) throws SQLException {
        this.logPSStimestamp(timestampColumnIndex, timestamp);
        this.ps.setTimestamp(timestampColumnIndex, timestamp);
    }

    private void debugResetPreparedStatementValues() {
        this.preparedStatementValues = new StringBuilder();
        this.preparedStatementValues.append(this.batchCount + 1);
        this.preparedStatementValues.append(": ");
    }

    private void debugAddSingleBatchToLog() {
        if (log.isDebugEnabled()) {
            this.preparedStatementList.add(this.preparedStatementValues.toString());
            this.debugResetPreparedStatementValues();
        }
    }

    private void debugInitialize() {
        if (log.isDebugEnabled()) {
            this.debugResetPreparedStatementValues();
            this.preparedStatementList = new ArrayList(1000);
        }
    }

    private void debugWriteLogs() {
        if (log.isDebugEnabled()) {
            log.debug(new Object[]{"Error executing following SQL batch: ", this.sql});
            for (String toLog : this.preparedStatementList) {
                log.debug(new Object[]{toLog});
            }
        }
    }

    private void logPSValue(int parameterIndex, int value) {
        if (log.isDebugEnabled()) {
            this.logPSValue("Integer: ", parameterIndex, value);
        }
    }

    private void logPSStimestamp(int parameterIndex, Timestamp value) {
        if (log.isDebugEnabled()) {
            this.logPSValue("Timestamp: ", parameterIndex, value.toString());
        }
    }

    private void logPSValue(int parameterIndex, long value) {
        if (log.isDebugEnabled()) {
            this.logPSValue("Long: ", parameterIndex, value);
        }
    }

    private void logPSValue(int parameterIndex, boolean value) {
        if (log.isDebugEnabled()) {
            this.logPSValue("Boolean: ", parameterIndex, value);
        }
    }

    private void logNullPSValue(int parameterIndex, int type) {
        if (log.isDebugEnabled()) {
            this.logPSValue("Null: ", parameterIndex, type);
        }
    }

    private void logPSValue(int parameterIndex, String value) {
        if (log.isDebugEnabled()) {
            this.logPSValue("String: ", parameterIndex, value);
        }
    }

    private void logPSValue(String type, int parameterIndex, Object value) {
        this.preparedStatementValues.append(type);
        this.preparedStatementValues.append(parameterIndex);
        this.preparedStatementValues.append(":");
        this.preparedStatementValues.append(value);
        this.preparedStatementValues.append(":");
    }
}

