/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LRUCache;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.RecordDetailsBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.User;
import com.ibm.cognos.pogo.zipi.impl.collector.Users;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CachedRecordDetailsTable {
    private static final int UNASSIGNED_MAP_SIZE = 128;
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final int LRU_CACHE_SIZE = 1000000;
    protected final ZipiDatabase zipiDB;
    private final LRUCache<String, Long> userCache;
    private final Map<String, UnassignedEntry> unassigned;
    private RecordDetailsBatchPreparedStatement recordDetailsBatch;

    public CachedRecordDetailsTable(ZipiDatabase zipiDB) {
        this.zipiDB = zipiDB;
        this.userCache = new LRUCache(1000000);
        this.unassigned = new HashMap<String, UnassignedEntry>(128);
    }

    public void save(String zipiID, User user, long userID, int threshold) {
        if (userID == 0L) {
            this.saveUnasigned(user, zipiID.toString(), threshold);
        } else {
            this.userCache.put(zipiID, userID);
            this.unassigned.remove(zipiID);
        }
    }

    private void saveUnasigned(User user, String zipiId, int threshold) {
        UnassignedEntry entry = new UnassignedEntry();
        entry.passport = user.getPassport();
        entry.threshold = threshold;
        this.unassigned.put(zipiId, entry);
    }

    public void writeRecordDetails(String zipiID, ZipiEvent event, int threshold) throws SQLException {
        UnassignedEntry entry = this.unassigned.get(zipiID);
        if (entry == null) {
            this.writeRecordDetailsImpl(zipiID, event, threshold);
        } else {
            entry.zipiEvent = event;
            entry.threshold = threshold;
        }
    }

    private void writeRecordDetailsImpl(String zipiID, ZipiEvent event, int threshold) throws SQLException {
        if (event == null) {
            return;
        }
        Long userID = (Long)this.userCache.get(zipiID);
        this.recordDetailsBatch.createBatch(zipiID, userID, event.getStartClockTime(), event.getElapsedClockTime(), threshold);
        this.userCache.remove(zipiID);
    }

    public void writeUnassigned(Users users) {
        for (Map.Entry<String, UnassignedEntry> entrySet : this.unassigned.entrySet()) {
            String zipiID = entrySet.getKey();
            UnassignedEntry unassignedEntry = entrySet.getValue();
            Long userId = (Long)users.getPassportCache().get(unassignedEntry.passport);
            if (userId == null) {
                log.warn(new Object[]{"Passport not found.  Username cannot be assigned."});
                if (unassignedEntry.passport == null) {
                    log.warn(new Object[]{"Passport was null"});
                }
            } else if (userId == 0L) {
                try {
                    userId = users.getOrCreateAnonymousUser(unassignedEntry.passport);
                }
                catch (SQLException e) {
                    log.error(new Object[]{"Failed getting anonymous user id."});
                    continue;
                }
            }
            this.userCache.put(zipiID, userId);
            try {
                this.writeRecordDetailsImpl(zipiID, unassignedEntry.zipiEvent, unassignedEntry.threshold);
            }
            catch (SQLException e) {
                log.error(new Object[]{"Failed writing record details."});
            }
        }
        this.unassigned.clear();
    }

    public void flushEvents() throws SQLException {
        if (this.recordDetailsBatch != null) {
            this.recordDetailsBatch.flushBatch();
        }
    }

    public void prepareBatch(LookupBatchPreparedStatement usersBatchPreparedStatement) throws SQLException {
        this.recordDetailsBatch = new RecordDetailsBatchPreparedStatement(this.zipiDB);
        this.recordDetailsBatch.addLookupBatchPreparedStatement(usersBatchPreparedStatement);
    }

    private static class UnassignedEntry {
        String passport;
        ZipiEvent zipiEvent;
        int threshold;

        private UnassignedEntry() {
        }
    }
}

