/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBean;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvents;
import java.util.Collection;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CollectedMBean {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String ZIPI_OBJECT_NAME = "com.cognos:type=ZIPI";
    protected String servername;
    protected ZipiMBean zipiMBean;
    protected Collection<ZipiMBeanEvents> allEvents;

    public String getServerName() {
        return this.servername;
    }

    public ZipiMBean getZipiMBean() {
        return this.zipiMBean;
    }

    public Collection<ZipiMBeanEvents> getAllEvents() {
        return this.allEvents;
    }

    public void collect(JMXDispatcher jmxDispatcher) throws Exception {
        this.servername = jmxDispatcher.getName();
        this.zipiMBean = this.getMBeanProxy(jmxDispatcher);
        this.allEvents = this.zipiMBean.removeAllEvents();
    }

    public boolean isCollected() {
        return this.allEvents != null;
    }

    private ZipiMBean getMBeanProxy(JMXDispatcher jmxDispatcher) throws MalformedObjectNameException {
        return jmxDispatcher.isLocalDispatcher() ? this.getLocalMBean() : this.getRemoteMBean(jmxDispatcher);
    }

    private ZipiMBean getLocalMBean() {
        log.debug(new Object[]{"Bypassing JMX to access local MBean"});
        return ZipiFactory.getStorage().getLocalMBean();
    }

    private ZipiMBean getRemoteMBean(JMXDispatcher jmxDispatcher) throws MalformedObjectNameException {
        log.debug(new Object[]{"Remote MBean access to ", this.servername});
        MBeanServerConnection mbsc = jmxDispatcher.getMbeanServerConnection();
        ObjectName objectName = new ObjectName(ZIPI_OBJECT_NAME);
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, objectName, ZipiMBean.class, false);
    }
}

