/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.impl.Marker;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.Activities;
import com.ibm.cognos.pogo.zipi.impl.collector.LogRecordBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.MarkerTables;
import com.ibm.cognos.pogo.zipi.impl.collector.Server;
import java.sql.SQLException;

public class LogRecords {
    private final ZipiDatabase zipiDB;
    private final Activities activities;
    private LogRecordBatchPreparedStatement logRecordBatch;
    private final MarkerTables markerTables;

    public LogRecords(ZipiDatabase zipiDB, Activities activities) {
        this(zipiDB, activities, new MarkerTables(zipiDB));
    }

    public LogRecords(ZipiDatabase zipiDB, Activities activities, MarkerTables markerTables) {
        this.zipiDB = zipiDB;
        this.activities = activities;
        this.markerTables = markerTables;
    }

    public void execute(ZipiEvent event, Server server, ZipiID zipiID) throws SQLException {
        if (event.isMarkerEvent()) {
            this.addMarker(zipiID, event.getMarker());
        } else {
            this.addEvent(event, server, zipiID);
        }
    }

    private void addMarker(ZipiID zipiID, Marker marker) throws SQLException {
        this.markerTables.saveMarker(zipiID, marker);
    }

    private void addEvent(ZipiEvent event, Server server, ZipiID zipiID) throws SQLException {
        this.addZipiId(zipiID);
        this.addServer(server);
        this.addProcessId(event);
        this.addThread(event);
        this.addStep(event);
        this.addActivity(event);
        this.addTime(server, event);
        this.logRecordBatch.addBatch();
    }

    private void addServer(Server server) throws SQLException {
        this.logRecordBatch.addServer(server.getIndex());
    }

    private void addZipiId(ZipiID zipiID) throws SQLException {
        this.logRecordBatch.addZipiId(zipiID.toString());
    }

    private void addTime(Server server, ZipiEvent event) throws SQLException {
        this.logRecordBatch.addTime(server.getCalculatedStartTime(event.getStartTime()), event.getElapsedTime(), event.getChildrenElapsedTime());
    }

    private void addStep(ZipiEvent event) throws SQLException {
        this.logRecordBatch.addStep(event.getStep());
    }

    private void addThread(ZipiEvent event) throws SQLException {
        this.logRecordBatch.addThread(event.getThreadName());
    }

    private void addProcessId(ZipiEvent event) throws SQLException {
        this.logRecordBatch.addProcessId(event.getProcessID());
    }

    private void addActivity(ZipiEvent event) throws SQLException {
        this.logRecordBatch.addActivity(this.activities.saveActivity(event));
    }

    public void flushEvents() throws SQLException {
        this.markerTables.close();
        this.activities.close();
        if (this.logRecordBatch != null) {
            this.logRecordBatch.flushBatch();
        }
    }

    public void prepareBatch(LookupBatchPreparedStatement serversBatchPreparedStatement) throws SQLException {
        this.logRecordBatch = new LogRecordBatchPreparedStatement(this.zipiDB);
        this.logRecordBatch.addLookupBatchPreparedStatement(serversBatchPreparedStatement);
        this.activities.prepareBatch();
        this.markerTables.prepareBatch();
        this.createAllLookupSQLBuilder();
        this.addLookupBatchPreparedStatement();
    }

    private void addLookupBatchPreparedStatement() {
        this.logRecordBatch.addLookupBatchPreparedStatement(this.activities.getLookupBatchPreparedStatement());
    }

    private void createAllLookupSQLBuilder() throws SQLException {
        this.markerTables.createLookupSQLBuilder();
        this.activities.createLookupSQLBuilder();
    }
}

