/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.RequestAdapter;
import com.ibm.cognos.pogo.zipi.ZipiAPI;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.collector.CollectedMBean;
import java.util.LinkedList;

public class MBeanCollectorThread
implements Runnable {
    private static final PogoLogger log = PogoLogger.getLogger();
    private JMXDispatcher jmxDispatcher;
    private LinkedList<CollectedMBean> queue;
    private RequestAdapter requestAdapter;

    public MBeanCollectorThread(JMXDispatcher jmxDispatcher, LinkedList<CollectedMBean> queue) {
        this.jmxDispatcher = jmxDispatcher;
        this.queue = queue;
        this.requestAdapter = ZipiAPI.createThreadRequestAdapter();
    }

    @Override
    public void run() {
        ZipiTimer zipiTimer = ZipiAPI.startOuterTimer(this.requestAdapter);
        zipiTimer.setAction("ZIPI.collectMBean");
        zipiTimer.setObjectPath(this.jmxDispatcher.getJmxUrl());
        try {
            CollectedMBean mbean = this.collectMBean();
            this.addMBeanToQueue(mbean);
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMBeanToQueue(CollectedMBean mbean) {
        LinkedList<CollectedMBean> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(mbean);
            this.queue.notify();
        }
    }

    private CollectedMBean collectMBean() {
        CollectedMBean mbean = new CollectedMBean();
        try {
            mbean.collect(this.jmxDispatcher);
        }
        catch (Exception e) {
            log.warn("Failed to collect events from " + this.jmxDispatcher.getJmxUrl(), (Throwable)e);
        }
        return mbean;
    }
}

