/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.MarkerType;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.impl.Marker;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.CubeRequest;
import com.ibm.cognos.pogo.zipi.impl.collector.ReportRequest;
import com.ibm.cognos.pogo.zipi.impl.collector.Request;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarkerTables {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final Map<MarkerType, Request> requestsByMarkerType = new HashMap<MarkerType, Request>();
    private final List<Request> requests = new ArrayList<Request>();

    public MarkerTables(ZipiDatabase zipiDB) {
        ReportRequest reportRequest = new ReportRequest(zipiDB);
        CubeRequest cubeRequest = new CubeRequest(zipiDB);
        this.addToRequestMap(reportRequest, cubeRequest);
        this.addToRequestList(reportRequest, cubeRequest);
    }

    protected void addToRequestMap(ReportRequest reportRequest, CubeRequest cubeRequest) {
        this.requestsByMarkerType.put(MarkerType.REPORT, reportRequest);
        this.requestsByMarkerType.put(MarkerType.DASHBOARD, reportRequest);
        this.requestsByMarkerType.put(MarkerType.ADHOC, reportRequest);
        this.requestsByMarkerType.put(MarkerType.CUBE, cubeRequest);
    }

    protected void addToRequestList(ReportRequest reportRequest, CubeRequest cubeRequest) {
        this.requests.add(reportRequest);
        this.requests.add(cubeRequest);
    }

    public void saveMarker(ZipiID zipiID, Marker marker) throws SQLException {
        Request request = this.requestsByMarkerType.get((Object)marker.getType());
        if (request != null) {
            request.saveMarker(zipiID, marker);
        } else {
            log.info(new Object[]{"Invalid marker: ", marker});
        }
    }

    public void close() {
        for (Request request : this.requests) {
            request.close();
        }
    }

    public void prepareBatch() throws SQLException {
        for (Request request : this.requests) {
            request.prepareBatch();
        }
    }

    public void createLookupSQLBuilder() throws SQLException {
        for (Request request : this.requests) {
            request.createLookupSQLBuilder();
        }
    }
}

