/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupSQLBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.SQLSelectBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeyCache;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeys;
import com.ibm.cognos.pogo.zipi.impl.collector.impl.MultiColumnSQLSelectBuilderImpl;
import com.ibm.cognos.pogo.zipi.impl.tables.MultiColumnKeyTable;
import java.sql.SQLException;
import java.util.List;

public class MultiColumnLookupSQLBuilder
extends LookupSQLBuilder {
    private MultiColumnSQLSelectBuilderImpl select;
    private LookupBatchPreparedStatement preparedStatement;
    private SecondaryKeys secondaryKeys;
    private String[] nameValues;
    private final MultiColumnKeyTable zipiTable;

    public MultiColumnLookupSQLBuilder(ZipiDatabase zipiDB, MultiColumnKeyTable zipiTable, List<SecondaryKeyCache> secondaryKeys) throws SQLException {
        this.zipiTable = zipiTable;
        this.select = new MultiColumnSQLSelectBuilderImpl(zipiDB, zipiTable, secondaryKeys);
        this.preparedStatement = new LookupBatchPreparedStatement(zipiDB, zipiTable.getInsertSql());
    }

    public void setValue(SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        this.secondaryKeys = secondaryKeys;
        this.nameValues = nameValues;
        this.select.setValue(secondaryKeys);
    }

    @Override
    public void setValue(String value) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public String getValue() {
        StringBuilder sb = new StringBuilder();
        for (String nameValue : this.nameValues) {
            sb.append(nameValue).append(',');
        }
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.secondaryKeys != null && this.nameValues != null;
    }

    @Override
    public SQLSelectBuilder getSQLSelectBuilder() {
        return this.select;
    }

    @Override
    public void addBatch(long nextId) throws SQLException {
        this.zipiTable.setInsertValues(this.preparedStatement, nextId, this.secondaryKeys, this.nameValues);
    }

    @Override
    public void flushBatch() throws SQLException {
        this.preparedStatement.flushBatch();
    }

    @Override
    public String getTable() {
        return this.zipiTable.getTableName();
    }

    @Override
    public void closeStatement() {
        this.select.closeStatement();
    }

    @Override
    public LookupBatchPreparedStatement getLookupBatchPreparedStatement() {
        return this.preparedStatement;
    }
}

