/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvents;
import com.ibm.cognos.pogo.zipi.impl.collector.Activities;
import com.ibm.cognos.pogo.zipi.impl.collector.CachedRecordDetailsTable;
import com.ibm.cognos.pogo.zipi.impl.collector.LogRecords;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.Server;
import com.ibm.cognos.pogo.zipi.impl.collector.User;
import com.ibm.cognos.pogo.zipi.impl.collector.Users;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log.Priority;

public class RecordDetails {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ZipiDatabase zipiDB;
    private final LogRecords logRecords;
    private final Users users;
    private final CachedRecordDetailsTable recordTable;
    private boolean isInterrupted;
    private final Storage storage;
    private ZipiMBeanEvents interruptedEvents;

    public RecordDetails(ZipiDatabase zipiDB, Activities activities) {
        this(zipiDB, new LogRecords(zipiDB, activities), ZipiFactory.getStorage());
    }

    public RecordDetails(ZipiDatabase zipiDB, LogRecords logRecords, Storage storage) {
        this.zipiDB = zipiDB;
        this.logRecords = logRecords;
        this.storage = storage;
        this.users = new Users(zipiDB);
        this.recordTable = new CachedRecordDetailsTable(zipiDB);
    }

    public void execute(ZipiMBeanEvents events, Server server) throws SQLException {
        try {
            if (this.zipiDB.isConnectedToDb()) {
                this.processEvents(events, server);
            }
        }
        finally {
            this.clearInterrupt();
        }
    }

    private void processEvents(ZipiMBeanEvents events, Server server) throws SQLException {
        User user = new User();
        this.scanForUserInfo(user, events);
        this.filterSummaryEvents(events);
        this.processEvents(events, server, user);
    }

    protected void filterSummaryEvents(ZipiMBeanEvents events) {
        if (events.isSummary()) {
            events.discardNonSummaryEvents();
        }
    }

    private void scanForUserInfo(User user, ZipiMBeanEvents events) throws SQLException {
        Iterator<ZipiEvent> event = events.iterator();
        while (event.hasNext()) {
            user.updateIdentity(event.next());
        }
        this.saveUserInfo(user, events.getZipiID(), events.getThreshold());
    }

    private void saveUserInfo(User user, ZipiID zipiID, int threshold) throws SQLException {
        long userId = this.users.lookupOrCreate(user);
        if (userId != -1L) {
            this.recordTable.save(zipiID.toString(), user, userId, threshold);
        }
    }

    private void processEvents(ZipiMBeanEvents events, Server server, User user) throws SQLException {
        ZipiID zipiID = events.getZipiID();
        int threshold = events.getThreshold();
        Iterator<ZipiEvent> it = events.iterator();
        while (it.hasNext()) {
            this.processEvent(it.next(), server, user, zipiID, threshold);
        }
    }

    private void processEvent(ZipiEvent event, Server server, User user, ZipiID zipiID, int threshold) throws SQLException {
        if (this.isInterrupted()) {
            this.storeInterruptedEvent(event, zipiID);
        } else {
            this.addEvent(event, server, zipiID, threshold);
        }
    }

    private void storeInterruptedEvent(ZipiEvent event, ZipiID zipiID) {
        log.info(new Object[]{"storeInterruptedEvent: ", event});
        if (this.interruptedEvents == null) {
            this.interruptedEvents = new ZipiMBeanEvents(zipiID);
        }
        this.interruptedEvents.add(event);
    }

    protected void addEvent(ZipiEvent event, Server server, ZipiID zipiID, int threshold) throws SQLException {
        this.addLogRecord(event, server, zipiID);
        if (!event.isMarkerEvent() && this.hasFirstZipiStep(event)) {
            this.addRecordDetails(zipiID, event, threshold);
        }
    }

    private void addLogRecord(ZipiEvent event, Server server, ZipiID zipiID) throws SQLException {
        this.logRecords.execute(event, server, zipiID);
    }

    private boolean hasFirstZipiStep(ZipiEvent event) {
        return "1".equals(event.getStep());
    }

    private void addRecordDetails(ZipiID zipiID, ZipiEvent event, int threshold) throws SQLException {
        this.recordTable.writeRecordDetails(zipiID.toString(), event, threshold);
    }

    public void flushEvents() throws SQLException {
        this.recordTable.writeUnassigned(this.users);
        this.users.close();
        try {
            this.logRecords.flushEvents();
        }
        finally {
            this.recordTable.flushEvents();
        }
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    public void prepareBatch(LookupBatchPreparedStatement serversBatchPreparedStatement) throws SQLException {
        this.users.createLookupSQLBuilder();
        this.logRecords.prepareBatch(serversBatchPreparedStatement);
        this.recordTable.prepareBatch(this.users.getLookupBatchPreparedStatement());
    }

    public void clearUsersCache() {
        this.users.clearCache();
    }

    public Long getCachedUserId(String userName) {
        return this.users.getCachedUserId(userName);
    }

    public Long getCachedPassportId(String passport) {
        return this.users.getCachedPassportId(passport);
    }

    public void interruptCollection() {
        log.info(new Object[]{"interruptCollection"});
        this.isInterrupted = true;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public void clearInterrupt() {
        this.isInterrupted = false;
        this.saveInterruptedEvents();
    }

    protected void saveInterruptedEvents() {
        if (this.interruptedEvents != null) {
            this.storage.updateEvents(this.toEventsCollection(this.interruptedEvents));
        }
        this.interruptedEvents = null;
    }

    protected List<ZipiMBeanEvents> toEventsCollection(ZipiMBeanEvents eventSet) {
        ArrayList<ZipiMBeanEvents> eventsCollection = new ArrayList<ZipiMBeanEvents>();
        eventsCollection.add(eventSet);
        return eventsCollection;
    }
}

