/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.impl.ZipiMBean;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvents;
import com.ibm.cognos.pogo.zipi.impl.ZipiStats;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import com.ibm.cognos.pogo.zipi.impl.collector.CollectedMBean;
import com.ibm.cognos.pogo.zipi.impl.collector.RecordDetails;
import java.sql.SQLException;
import java.util.Collection;

public class Server {
    public static final int MAX_LENGTH = 100;
    private static ZipiWallTime wallTime = new ZipiWallTime();
    private final ZipiStats stats;
    private final long index;
    private final RecordDetails recordDetails;
    private long currentMBeanServerTime;
    private long currentCollectionServerTime;
    private final String serverName;
    private boolean isInterrupted;

    public static ZipiWallTime setWallTimeForTesting(ZipiWallTime newWallTime) {
        ZipiWallTime originalWallTime = wallTime;
        wallTime = newWallTime;
        return originalWallTime;
    }

    public Server(long index) {
        this(index, null, null, ZipiStats.NULL);
    }

    public Server(long index, RecordDetails recordDetails, String serverName, ZipiStats totalStats) {
        this.index = index;
        this.recordDetails = recordDetails;
        this.serverName = this.shortenIfNeeded(serverName);
        this.stats = new ZipiStats(serverName, totalStats);
    }

    private String shortenIfNeeded(String serverName) {
        return this.isTooLong(serverName) ? this.shorten(serverName) : serverName;
    }

    private boolean isTooLong(String serverName) {
        return serverName != null && serverName.length() > 100;
    }

    private String shorten(String serverName) {
        return serverName.substring(0, 100);
    }

    public long getIndex() {
        return this.index;
    }

    public long getCalculatedStartTime(long originalStartTime) {
        return this.currentCollectionServerTime - (this.currentMBeanServerTime - originalStartTime);
    }

    public void saveTimeOffset(ZipiMBean zipiMBean) {
        this.currentMBeanServerTime = zipiMBean.getCurrentTime();
        this.currentCollectionServerTime = this.getCurrentCollectionServerTime();
    }

    private long getCurrentCollectionServerTime() {
        return wallTime.getCurrentTimeInNanos();
    }

    public void execute(CollectedMBean mbean) throws SQLException {
        this.stats.collectionStarted();
        int eventCount = this.recordAllEvents(mbean);
        this.stats.collectionEnded(eventCount);
    }

    private int recordAllEvents(CollectedMBean mbean) throws SQLException {
        Collection<ZipiMBeanEvents> allEvents = mbean.getAllEvents();
        this.saveToDatabase(allEvents);
        return allEvents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDatabase(Collection<ZipiMBeanEvents> allEvents) throws SQLException {
        try {
            for (ZipiMBeanEvents events : allEvents) {
                if (!events.getZipiID().shouldLog() || this.isInterrupted()) continue;
                this.recordDetails.execute(events, this);
            }
        }
        finally {
            this.clearInterrupt();
        }
    }

    public void logStats() {
        this.stats.writeToLog();
    }

    public String getName() {
        return this.serverName;
    }

    boolean isInterrupted() {
        return this.isInterrupted;
    }

    public void interruptCollection() {
        this.isInterrupted = true;
        this.recordDetails.interruptCollection();
    }

    protected void clearInterrupt() {
        this.isInterrupted = false;
        this.recordDetails.clearInterrupt();
    }
}

