/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.SQLSelectBuilder;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLSelectBuilderImpl
implements SQLSelectBuilder {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String value;
    private PreparedStatement ps;
    private String sql;

    public SQLSelectBuilderImpl(String table, String idColumn, String nameColumn, ZipiDatabase database, String lookupSql) throws SQLException {
        this.sql = String.format(lookupSql, idColumn, table, nameColumn);
        this.ps = database.prepareStatement(this.sql);
    }

    @Override
    public String getString() {
        return this.sql;
    }

    @Override
    public PreparedStatement getPreparedStatement() throws SQLException {
        return this.ps;
    }

    public void setValue(String value) throws SQLException {
        this.value = value;
        this.ps.setString(1, value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void closeStatement() {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (SQLException e) {
                log.warn("Following exception occurred while closing Select prepared statement: ", (Throwable)e);
            }
        }
    }
}

