/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.MultiColumnPrimaryKeyCache;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKey;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeys;
import com.ibm.cognos.pogo.zipi.impl.tables.AllTableNames;
import com.ibm.cognos.pogo.zipi.impl.tables.MultiColumnKeyTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ActivityTable
extends MultiColumnKeyTable {
    public static String TABLE_NAME = AllTableNames.ACTIVITY_ACTIONS;
    public static final String COL_ACTION_NAME = "ACTIONNAME";
    public static final String COL_ACTION_ID = "ACTIONID";
    public static final String COL_OBJECT_NAME = "OBJECTNAME";
    public static final int COL_OBJECT_NAME_SIZE = 500;
    public static final String COL_OBJECT_ID = "OBJECTID";
    public static final String COL_SERVICE_NAME = "SERVICENAME";
    public static final String COL_SERVICE_ID = "SERVICEID";
    public static final String COL_PROCESS_NAME = "PROCESSNAME";
    public static final String SELECT_SQL = "SELECT (ID) FROM " + TABLE_NAME + " WHERE " + "ACTIONID" + "=? AND " + "OBJECTID" + "=? AND " + "SERVICEID" + "=?";
    public static final String INSERT_SQL = ActivityTable.buildInsertSql(TABLE_NAME, "ID", "ACTIONNAME", "ACTIONID", "OBJECTNAME", "OBJECTID", "SERVICENAME", "SERVICEID", "PROCESSNAME");

    public ActivityTable() {
        super(TABLE_NAME, COL_ACTION_NAME, SELECT_SQL, INSERT_SQL);
        this.addIdColumn(COL_ACTION_ID);
        this.addIdColumn(COL_OBJECT_ID);
        this.addIdColumn(COL_SERVICE_ID);
    }

    public static MultiColumnPrimaryKeyCache createPrimaryKeyCache(ZipiDatabase zipiDB) {
        MultiColumnPrimaryKeyCache keys = new MultiColumnPrimaryKeyCache(zipiDB, TABLE_NAME);
        keys.addSecondaryKey(COL_ACTION_ID, COL_ACTION_NAME, 100);
        keys.addSecondaryKey(COL_OBJECT_ID, COL_OBJECT_NAME, 500);
        keys.addSecondaryKey(COL_SERVICE_ID, COL_SERVICE_NAME, 100);
        keys.addColumn(COL_PROCESS_NAME);
        return keys;
    }

    @Override
    protected void addMoreTableColumns() {
        super.addMoreTableColumns();
        this.dbServer.addIntColumn(COL_ACTION_ID, " NOT NULL");
        this.dbServer.addStringColumn(COL_OBJECT_NAME, 500);
        this.dbServer.addIntColumn(COL_OBJECT_ID, " NOT NULL");
        this.dbServer.addStringColumn(COL_SERVICE_NAME, 100);
        this.dbServer.addIntColumn(COL_SERVICE_ID, " NOT NULL");
        this.dbServer.addStringColumn(COL_PROCESS_NAME, 100);
    }

    @Override
    public void setSelectValues(PreparedStatement ps, SecondaryKeys secondaryKeys) throws SQLException {
        super.setSelectValues(ps, secondaryKeys);
        for (int i = 0; i < secondaryKeys.size(); ++i) {
            this.setPreparedStatementParameter(ps, i + 1, ((SecondaryKey)secondaryKeys.get(i)).getID());
        }
    }

    @Override
    public void setInsertValues(LookupBatchPreparedStatement ps, long primaryKey, SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        super.setInsertValues(ps, primaryKey, secondaryKeys, nameValues);
        this.setLong(ps, 1, primaryKey);
        this.setString(ps, 2, ((SecondaryKey)secondaryKeys.get(0)).getName());
        this.setLong(ps, 3, ((SecondaryKey)secondaryKeys.get(0)).getID());
        this.setString(ps, 4, ((SecondaryKey)secondaryKeys.get(1)).getName());
        this.setLong(ps, 5, ((SecondaryKey)secondaryKeys.get(1)).getID());
        this.setString(ps, 6, ((SecondaryKey)secondaryKeys.get(2)).getName());
        this.setLong(ps, 7, ((SecondaryKey)secondaryKeys.get(2)).getID());
        this.setString(ps, 8, nameValues[3]);
        ps.addBatch();
    }
}

