/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.tables.AllTableNames;
import com.ibm.cognos.pogo.zipi.impl.tables.ZipiTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CogTimesTable
extends ZipiTable {
    public static String TABLE_NAME = AllTableNames.COGTIMES;
    public static final String COL_TIMES_ID = "ID";
    public static final String COL_HOUR = "HOUR";
    public static final String COL_MINUTE = "MINUTE";
    public static final String COL_SECOND = "SECOND";

    public CogTimesTable() {
        super(TABLE_NAME);
    }

    @Override
    public String[] getCreateTableSql() {
        this.dbServer.startCreateTableCommand(TABLE_NAME);
        this.dbServer.addPrimaryKey(COL_TIMES_ID);
        this.dbServer.addIntColumn(COL_HOUR, " NOT NULL");
        this.dbServer.addIntColumn(COL_MINUTE, " NOT NULL");
        this.dbServer.addIntColumn(COL_SECOND, " NOT NULL");
        return this.dbServer.getSqlForCreatingTable();
    }

    @Override
    public void populate(ZipiDatabase zipiDatabase, int hours) throws SQLException {
        String insertClause = this.getInsertPreamble();
        String id = "%02d%02d%02d";
        PreparedStatement pStatement = zipiDatabase.prepareStatement(insertClause + "(?,?,?,?)");
        for (int hour = 0; hour < hours; ++hour) {
            for (int min = 0; min < 60; ++min) {
                for (int sec = 0; sec < 60; ++sec) {
                    pStatement.setString(1, String.format(id, hour, min, sec));
                    pStatement.setInt(2, hour);
                    pStatement.setInt(3, min);
                    pStatement.setInt(4, sec);
                    pStatement.addBatch();
                }
                zipiDatabase.executeBatchSQL_NoCommit(pStatement);
            }
        }
        zipiDatabase.commitTransactions();
    }
}

