/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.tables.ZipiTable;
import java.sql.SQLException;

public abstract class IdTable
extends ZipiTable {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final int STARTUP_INCREMENT_TO_AVOID_COLLISIONS = 0;
    private final String idColumn;
    private final String nameColumn;
    private final int nameColumnSize;
    private long nextID;

    public IdTable(String tableName, String nameColumn) {
        this(tableName, nameColumn, 100);
    }

    public IdTable(String tableName, String nameColumn, int nameColumnSize) {
        this(tableName, "ID", nameColumn, nameColumnSize);
    }

    public IdTable(String tableName, String idColumn, String nameColumn, int nameColumnSize) {
        super(tableName);
        this.idColumn = idColumn;
        this.nameColumn = nameColumn;
        this.nameColumnSize = nameColumnSize;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public String getNameColumn() {
        return this.nameColumn;
    }

    public int getNameColumnSize() {
        return this.nameColumnSize;
    }

    @Override
    public String[] getCreateTableSql() {
        this.dbServer.startCreateTableCommand(this.getTableName());
        this.addTableIdColumn(this.idColumn);
        this.dbServer.addStringColumn(this.nameColumn, this.nameColumnSize);
        this.addMoreTableColumns();
        return this.dbServer.getSqlForCreatingTable();
    }

    protected void addTableIdColumn(String idColumn) {
        this.dbServer.addPrimaryKey(idColumn);
    }

    protected void addMoreTableColumns() {
    }

    @Override
    public String[] getDropTableSql() {
        return this.dbServer.getSqlForDroppingLookupTable(this.getTableName());
    }

    @Override
    public long getNextID() {
        return ++this.nextID;
    }

    @Override
    public void readNextID(ZipiDatabase zipiDatabase) throws SQLException {
        this.nextID = this.readNextID(zipiDatabase, this.idColumn);
    }

    protected long readNextID(ZipiDatabase zipiDatabase, String column) throws SQLException {
        long maxValue = zipiDatabase.getMaxValue(this.getTableName(), column);
        long nextIdValue = maxValue + 0L;
        log.debug(new Object[]{"Next ", column, " for ", this.getTableName(), " table is: ", nextIdValue});
        return nextIdValue;
    }

    @Override
    public void reset() {
        super.reset();
        this.nextID = 0L;
    }
}

