/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.transaction;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.performance.transaction.PerformanceTransactionAdapter;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;

public class RootHandlerTransaction
extends PerformanceTransactionAdapter {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final MessageContext mc;

    public RootHandlerTransaction(MessageContext mc) {
        this.mc = mc;
    }

    public void commit(Object additionalData) {
        log.debug(new Object[]{"commit"});
        ZipiTimer currentTimer = ZipiFactory.getCurrentTimer();
        if (currentTimer.isActive()) {
            this.updateCurrentTimer(currentTimer);
        }
    }

    private void updateCurrentTimer(ZipiTimer currentTimer) {
        this.updateZipiAction(currentTimer);
        this.updateZipiPassport(currentTimer);
    }

    private void updateZipiAction(ZipiTimer zipiTimer) {
        String soapAction = (String)this.mc.getProperty("request.soapaction");
        zipiTimer.setAction(soapAction);
    }

    private void updateZipiPassport(ZipiTimer zipiTimer) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.mc.getProperty("request.envelope");
        String passportId = requestEnvelope != null ? requestEnvelope.getPassportID() : null;
        zipiTimer.setPassport(passportId);
    }
}

