/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.EmptyResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import com.sun.rowset.CachedRowSetImpl;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;

public class OracleDatabaseMetadataAdaptor
extends BaseDatabaseMetadataAdaptor {
    public static final int FUNCTIONCOLUMNS_SPECIFIC_NAME_COLNO = 17;
    public static final int PACKAGE_NAME_COLNO = 1;
    public static final int PROCEDURE_NAME = 3;

    public OracleDatabaseMetadataAdaptor(Object obj, AdaptorFactory factory) {
        super((DatabaseMetaData)obj, factory);
    }

    protected ResultSet getIndexInfoImpl(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (table.contains("\u20ac")) {
            return new EmptyResultSetAdaptor();
        }
        return this.dmd.getIndexInfo(catalog, schema, table, unique, approximate);
    }

    public ResultSet getProcedureColumnsImpl(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (procedureNamePattern != null) {
            String[] parts = procedureNamePattern.split("\\.");
            if (parts.length == 2) {
                catalog = parts[0];
                procedureNamePattern = parts[1];
            } else {
                catalog = procedureNamePattern.contains("//") ? null : "";
            }
        }
        Object rs = this.dmd.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        rs = this.procedureImportSortResultSet((ResultSet)rs);
        rs = new OracleRoutineNameResultSetAdaptor((ResultSet)rs, this.factory);
        return rs;
    }

    public ResultSet getProceduresImpl(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        ResultSet rs = this.dmd.getProcedures(catalog, schemaPattern, procedureNamePattern);
        rs = this.cleanProcedureResultSet(rs);
        return rs;
    }

    public ResultSet getFunctionColumnsImpl(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        Object rs = this.dmd.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
        rs = this.removeDuplicates((ResultSet)rs);
        rs = this.sortResultSet((ResultSet)rs);
        rs = new OracleFunctionColumnsResultSetAdaptor((ResultSet)rs, this.factory);
        return rs;
    }

    public ResultSet getFunctionsImpl(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        Object rs = this.dmd.getFunctions(catalog, schemaPattern, functionNamePattern);
        rs = new OracleRoutineNameResultSetAdaptor((ResultSet)rs, this.factory);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ResultSet procedureImportSortResultSet(ResultSet rs) throws SQLException, SQLFeatureNotSupportedException {
        try {
            CachedRowSetImpl crs = new CachedRowSetImpl();
            crs.populate(rs);
            ArrayList<Object> sortList = new ArrayList<Object>();
            while (crs.next()) {
                ResultSetRow row = new ResultSetRow(crs);
                sortList.add(row);
            }
            Collections.sort(sortList);
            crs.beforeFirst();
            for (ResultSetRow resultSetRow : sortList) {
                if (!crs.next()) continue;
                crs.updateString(1, resultSetRow.FUNCTION_CAT);
                crs.updateString(2, resultSetRow.FUNCTION_SCHEM);
                crs.updateString(3, resultSetRow.FUNCTION_NAME);
                crs.updateString(4, resultSetRow.COLUMN_NAME);
                crs.updateInt(5, resultSetRow.COLUMN_TYPE);
                crs.updateInt(6, resultSetRow.DATA_TYPE);
                crs.updateString(7, resultSetRow.TYPE_NAME);
                crs.updateInt(8, resultSetRow.PRECISION);
                crs.updateInt(9, resultSetRow.LENGTH);
                crs.updateInt(10, resultSetRow.SCALE);
                crs.updateInt(11, resultSetRow.RADIX);
                crs.updateInt(12, resultSetRow.NULLABLE);
                crs.updateString(13, resultSetRow.REMARKS);
                crs.updateString(14, resultSetRow.COLUMN_DEF);
                crs.updateString(15, resultSetRow.SQL_DATA_TYPE);
                crs.updateString(16, resultSetRow.SQL_DATETIME_SUB);
                crs.updateInt(17, resultSetRow.CHAR_OCTET_LENGTH);
                crs.updateInt(18, resultSetRow.ORDINAL_POSITION);
                crs.updateString(19, resultSetRow.IS_NULLABLE);
                crs.updateString(20, resultSetRow.SPECIFIC_NAME);
                crs.updateInt(21, resultSetRow.SEQUENCE);
                crs.updateString(22, resultSetRow.OVERLOAD);
                crs.updateString(23, resultSetRow.DEFAULT_VALUE);
            }
            crs.beforeFirst();
            boolean state = false;
            Object var5_7 = null;
            while (crs.next()) {
                void var5_8;
                if (!state) {
                    if (crs.getInt(5) != 5) continue;
                    state = true;
                    crs.deleteRow();
                    String string = crs.getString(1) + "." + crs.getString(2) + "." + crs.getString(3) + "." + crs.getString(22);
                    continue;
                }
                if (!var5_8.equals(crs.getString(1) + "." + crs.getString(2) + "." + crs.getString(3) + "." + crs.getString(22))) {
                    if (crs.getInt(5) == 5) {
                        state = true;
                        crs.deleteRow();
                        String string = crs.getString(1) + "." + crs.getString(2) + "." + crs.getString(3) + "." + crs.getString(22);
                        continue;
                    }
                    state = false;
                    continue;
                }
                crs.deleteRow();
            }
            crs.beforeFirst();
            CachedRowSetImpl cachedRowSetImpl = crs;
            return cachedRowSetImpl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet removeDuplicates(ResultSet rs) throws SQLException, SQLFeatureNotSupportedException {
        try {
            CachedRowSetImpl crs = new CachedRowSetImpl();
            crs.populate(rs);
            ArrayList<String> setList = new ArrayList<String>();
            while (crs.next()) {
                String packageName = crs.getString(1);
                String schemaName = crs.getString(2);
                String functionName = crs.getString(3);
                String columnName = crs.getString(4);
                Short overload = crs.getShort(22);
                if (setList.contains(packageName + "." + schemaName + "." + functionName + "." + columnName + "." + overload)) {
                    crs.deleteRow();
                    continue;
                }
                setList.add(packageName + "." + schemaName + "." + functionName + "." + columnName + "." + overload);
            }
            crs.beforeFirst();
            CachedRowSetImpl cachedRowSetImpl = crs;
            return cachedRowSetImpl;
        }
        finally {
            rs.close();
        }
    }

    public ResultSet sortResultSet(ResultSet rs) throws SQLException, SQLFeatureNotSupportedException {
        ArrayList<ResultSetRow> sortList = new ArrayList<ResultSetRow>();
        while (rs.next()) {
            ResultSetRow row = new ResultSetRow(rs);
            sortList.add(row);
        }
        Collections.sort(sortList);
        if (rs.first()) {
            rs.beforeFirst();
            int sortListIt = 0;
            while (rs.next()) {
                rs.updateString(1, ((ResultSetRow)sortList.get((int)sortListIt)).FUNCTION_CAT);
                rs.updateString(2, ((ResultSetRow)sortList.get((int)sortListIt)).FUNCTION_SCHEM);
                rs.updateString(3, ((ResultSetRow)sortList.get((int)sortListIt)).FUNCTION_NAME);
                rs.updateString(4, ((ResultSetRow)sortList.get((int)sortListIt)).COLUMN_NAME);
                rs.updateInt(5, ((ResultSetRow)sortList.get((int)sortListIt)).COLUMN_TYPE);
                rs.updateInt(6, ((ResultSetRow)sortList.get((int)sortListIt)).DATA_TYPE);
                rs.updateString(7, ((ResultSetRow)sortList.get((int)sortListIt)).TYPE_NAME);
                rs.updateInt(8, ((ResultSetRow)sortList.get((int)sortListIt)).PRECISION);
                rs.updateInt(9, ((ResultSetRow)sortList.get((int)sortListIt)).LENGTH);
                rs.updateInt(10, ((ResultSetRow)sortList.get((int)sortListIt)).SCALE);
                rs.updateInt(11, ((ResultSetRow)sortList.get((int)sortListIt)).RADIX);
                rs.updateInt(12, ((ResultSetRow)sortList.get((int)sortListIt)).NULLABLE);
                rs.updateString(13, ((ResultSetRow)sortList.get((int)sortListIt)).REMARKS);
                rs.updateString(14, ((ResultSetRow)sortList.get((int)sortListIt)).COLUMN_DEF);
                rs.updateString(15, ((ResultSetRow)sortList.get((int)sortListIt)).SQL_DATA_TYPE);
                rs.updateString(16, ((ResultSetRow)sortList.get((int)sortListIt)).SQL_DATETIME_SUB);
                rs.updateInt(17, ((ResultSetRow)sortList.get((int)sortListIt)).CHAR_OCTET_LENGTH);
                rs.updateInt(18, ((ResultSetRow)sortList.get((int)sortListIt)).ORDINAL_POSITION);
                rs.updateString(19, ((ResultSetRow)sortList.get((int)sortListIt)).IS_NULLABLE);
                rs.updateString(20, ((ResultSetRow)sortList.get((int)sortListIt)).SPECIFIC_NAME);
                rs.updateInt(21, ((ResultSetRow)sortList.get((int)sortListIt)).SEQUENCE);
                rs.updateString(22, ((ResultSetRow)sortList.get((int)sortListIt)).OVERLOAD);
                rs.updateString(23, ((ResultSetRow)sortList.get((int)sortListIt)).DEFAULT_VALUE);
                ++sortListIt;
            }
        }
        rs.beforeFirst();
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet cleanProcedureResultSet(ResultSet rs) throws SQLException {
        try {
            CachedRowSetImpl crs = new CachedRowSetImpl();
            crs.populate(rs);
            if (crs.first()) {
                crs.beforeFirst();
                while (crs.next()) {
                    if (crs.getInt(8) == 2) {
                        crs.deleteRow();
                        continue;
                    }
                    if (crs.getString(1) == null) continue;
                    crs.updateString(3, crs.getString(1) + "." + crs.getString(3));
                    crs.updateString(1, null);
                }
            }
            crs.beforeFirst();
            CachedRowSetImpl cachedRowSetImpl = crs;
            return cachedRowSetImpl;
        }
        finally {
            rs.close();
        }
    }

    public static class OracleFunctionColumnsResultSetAdaptor
    extends BaseResultSetAdaptor {
        OracleFunctionColumnsResultSetAdaptor(ResultSet rs, AdaptorFactory f) {
            super(rs, f);
        }

        public String getString(int colNo) throws SQLException {
            if (colNo == 17) {
                return "";
            }
            if (colNo == 1) {
                return null;
            }
            if (colNo == 3) {
                String pn = this.rs.getString(1);
                if (pn == null || pn.isEmpty()) {
                    return this.rs.getString(colNo);
                }
                return pn + '.' + this.rs.getString(colNo);
            }
            return this.rs.getString(colNo);
        }
    }

    public static class OracleRoutineNameResultSetAdaptor
    extends BaseResultSetAdaptor {
        OracleRoutineNameResultSetAdaptor(ResultSet rs, AdaptorFactory f) {
            super(rs, f);
        }

        public String getString(int colNo) throws SQLException {
            if (colNo == 1) {
                return null;
            }
            if (colNo == 3) {
                String pn = this.rs.getString(1);
                if (pn == null || pn.isEmpty()) {
                    return this.rs.getString(colNo);
                }
                return pn + '.' + this.rs.getString(colNo);
            }
            return this.rs.getString(colNo);
        }
    }

    private class ResultSetRow
    implements Comparable<ResultSetRow> {
        String FUNCTION_CAT;
        String FUNCTION_SCHEM;
        String FUNCTION_NAME;
        String COLUMN_NAME;
        int COLUMN_TYPE;
        int DATA_TYPE;
        String TYPE_NAME;
        int PRECISION;
        int LENGTH;
        int SCALE;
        int RADIX;
        int NULLABLE;
        String REMARKS;
        String COLUMN_DEF;
        String SQL_DATA_TYPE;
        String SQL_DATETIME_SUB;
        int CHAR_OCTET_LENGTH;
        int ORDINAL_POSITION;
        String IS_NULLABLE;
        String SPECIFIC_NAME;
        int SEQUENCE;
        String OVERLOAD;
        String DEFAULT_VALUE;

        public ResultSetRow(ResultSet rs) {
            try {
                this.FUNCTION_CAT = rs.getString(1);
                this.FUNCTION_SCHEM = rs.getString(2);
                this.FUNCTION_NAME = rs.getString(3);
                this.COLUMN_NAME = rs.getString(4);
                this.COLUMN_TYPE = rs.getInt(5);
                this.DATA_TYPE = rs.getInt(6);
                this.TYPE_NAME = rs.getString(7);
                this.PRECISION = rs.getInt(8);
                this.LENGTH = rs.getInt(9);
                this.SCALE = rs.getInt(10);
                this.RADIX = rs.getInt(11);
                this.NULLABLE = rs.getInt(12);
                this.REMARKS = rs.getString(13);
                this.COLUMN_DEF = rs.getString(14);
                this.SQL_DATA_TYPE = rs.getString(15);
                this.SQL_DATETIME_SUB = rs.getString(16);
                this.CHAR_OCTET_LENGTH = rs.getInt(17);
                this.ORDINAL_POSITION = rs.getInt(18);
                this.IS_NULLABLE = rs.getString(19);
                this.SPECIFIC_NAME = rs.getString(20);
                this.SEQUENCE = rs.getInt(21);
                this.OVERLOAD = rs.getString(22);
                this.DEFAULT_VALUE = rs.getString(23);
            }
            catch (Exception e) {
                this.FUNCTION_CAT = null;
                this.FUNCTION_SCHEM = null;
                this.FUNCTION_NAME = null;
                this.COLUMN_NAME = null;
                this.COLUMN_TYPE = 0;
                this.DATA_TYPE = 0;
                this.TYPE_NAME = null;
                this.PRECISION = 0;
                this.LENGTH = 0;
                this.SCALE = 0;
                this.RADIX = 0;
                this.NULLABLE = 0;
                this.REMARKS = null;
                this.COLUMN_DEF = null;
                this.SQL_DATA_TYPE = null;
                this.SQL_DATETIME_SUB = null;
                this.CHAR_OCTET_LENGTH = 0;
                this.ORDINAL_POSITION = 0;
                this.IS_NULLABLE = null;
                this.SPECIFIC_NAME = null;
                this.SEQUENCE = 0;
                this.OVERLOAD = null;
                this.DEFAULT_VALUE = null;
            }
        }

        @Override
        public int compareTo(ResultSetRow rsr) {
            int rsrOverload;
            int thisOverload;
            String specificName2;
            String specificName1 = this.FUNCTION_CAT + "." + this.FUNCTION_SCHEM + "." + this.FUNCTION_NAME;
            int comparator = specificName1.compareTo(specificName2 = rsr.FUNCTION_CAT + "." + rsr.FUNCTION_SCHEM + "." + rsr.FUNCTION_NAME);
            if (comparator < 0) {
                return -1;
            }
            if (comparator > 0) {
                return 1;
            }
            try {
                thisOverload = Integer.parseInt(this.OVERLOAD);
                rsrOverload = Integer.parseInt(rsr.OVERLOAD);
            }
            catch (NumberFormatException e) {
                thisOverload = 0;
                rsrOverload = 0;
            }
            if (thisOverload < rsrOverload) {
                return -1;
            }
            if (thisOverload > rsrOverload) {
                return 1;
            }
            if (this.ORDINAL_POSITION < rsr.ORDINAL_POSITION) {
                return -1;
            }
            if (this.ORDINAL_POSITION == rsr.ORDINAL_POSITION) {
                return 0;
            }
            return 1;
        }
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new OracleDatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

