/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseMetadataMapper;

public class OracleMetadataMapper
extends BaseMetadataMapper {
    private static final String NUMBER = "NUMBER";
    private static final int ORACLE_SCALE = 8;
    private static final int ORACLE_NEGATIVE_SCALE = -99;
    private static final int ORACLE_NEGATIVE_SCALE1 = -127;
    private static final int INTEGER_MAX_DIGITS = 10;
    private static final int LONG_MAX_DIGITS = 19;
    private boolean decfloat = false;

    OracleMetadataMapper(AdaptorFactory theFactory) {
        super(theFactory);
    }

    public int mapType(int origType, String origTypeName, int origPrecision, int origScale) {
        if (!origTypeName.equalsIgnoreCase(NUMBER)) {
            return super.mapType(origType, origTypeName, origPrecision, origScale);
        }
        Number num = new Number(origPrecision, origScale, this.isDecfloat());
        return num.type;
    }

    public int mapPrecision(int origType, String origTypeName, int origPrecision, int origScale) {
        if (!origTypeName.equalsIgnoreCase(NUMBER)) {
            return super.mapPrecision(origType, origTypeName, origPrecision, origScale);
        }
        Number num = new Number(origPrecision, origScale, this.isDecfloat());
        return num.precision;
    }

    public int mapScale(int origType, String origTypeName, int origPrecision, int origScale) {
        if (!origTypeName.equalsIgnoreCase(NUMBER)) {
            return super.mapScale(origType, origTypeName, origPrecision, origScale);
        }
        Number num = new Number(origPrecision, origScale, this.isDecfloat());
        return num.scale;
    }

    public void setDecfloat(boolean theDecfloat) {
        this.decfloat = theDecfloat;
    }

    public boolean isDecfloat() {
        return this.decfloat;
    }

    private static class Number {
        public int type = 3;
        public int precision;
        public int scale;

        Number(int origPrecision, int origScale, boolean decfloat) {
            this.precision = origPrecision;
            this.scale = origScale;
            if (origPrecision == 0 || origScale == -99 || origScale == -127) {
                this.type = decfloat ? 3 : 8;
                this.precision = 0;
                this.scale = 0;
                return;
            }
            if (origScale < 0) {
                origPrecision -= origScale;
                origScale = 0;
            }
            if (origPrecision >= 10) {
                if (origPrecision < 19) {
                    this.type = -5;
                    this.scale = origScale;
                    this.precision = 0;
                } else {
                    this.type = 3;
                    this.scale = origScale;
                    this.precision = origPrecision;
                }
            } else if (this.precision >= 1 && this.precision < 10) {
                if (this.scale >= 8) {
                    this.type = 8;
                    this.scale = 0;
                    this.precision = 0;
                } else {
                    this.type = 4;
                    this.scale = origScale;
                    this.precision = 0;
                }
            }
        }
    }
}

