/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgresDatabaseMetadataAdaptor
extends BaseDatabaseMetadataAdaptor {
    private static final String GREENPLUM = "greenplum";
    private int databaseMajorForNonPostgresSQLDB = 0;
    private int databaseMinorForNonPostgresSQLDB = 0;
    private int databaseSubminorForNonPostgresSQLDB = 0;
    private String productNameForNonPostgresSQLDB = "UNKNOWN";
    private boolean retrievedInfo = false;
    private Pattern ptn = Pattern.compile("(.*?)((?i)(Greenplum)(\\s+Database))(\\s+)((\\d+)\\.(\\d+)\\.(\\d+))(.*)");

    public PostgresDatabaseMetadataAdaptor(Object obj, AdaptorFactory factory) {
        super((DatabaseMetaData)obj, factory);
        if (GREENPLUM.equalsIgnoreCase(factory.getSubType())) {
            this.getPostresVersion();
        }
    }

    protected int getDatabaseMajorVersionImpl() throws SQLException {
        int majorVersion = this.dmd.getDatabaseMajorVersion();
        if ("Mongo".equalsIgnoreCase(this.factory.getSubType())) {
            majorVersion = this.getDatabaseVersionFromProductVersionText()[0];
        } else if (GREENPLUM.equalsIgnoreCase(this.factory.getSubType())) {
            return this.databaseMajorForNonPostgresSQLDB;
        }
        return majorVersion;
    }

    protected int getDatabaseMinorVersionImpl() throws SQLException {
        int minorVersion = this.dmd.getDatabaseMinorVersion();
        if ("Mongo".equalsIgnoreCase(this.factory.getSubType())) {
            minorVersion = this.getDatabaseVersionFromProductVersionText()[1];
        } else if (GREENPLUM.equalsIgnoreCase(this.factory.getSubType())) {
            return this.databaseMinorForNonPostgresSQLDB;
        }
        return minorVersion;
    }

    protected String getDatabaseProductNameImpl() throws SQLException {
        if (GREENPLUM.equalsIgnoreCase(this.factory.getSubType())) {
            return this.productNameForNonPostgresSQLDB;
        }
        return this.dmd.getDatabaseProductName();
    }

    protected String getDatabaseProductVersionImpl() throws SQLException {
        if (GREENPLUM.equalsIgnoreCase(this.factory.getSubType())) {
            return String.format("%d.%d.%d", this.databaseMajorForNonPostgresSQLDB, this.databaseMinorForNonPostgresSQLDB, this.databaseSubminorForNonPostgresSQLDB);
        }
        return this.dmd.getDatabaseProductVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPostresVersion() {
        if (!this.retrievedInfo) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                Matcher versionInfo;
                stmt = super.getConnection().createStatement();
                stmt.execute("select version()");
                rs = stmt.getResultSet();
                String s = null;
                if (rs.next() && (versionInfo = this.ptn.matcher(s = rs.getString(1))).matches()) {
                    this.productNameForNonPostgresSQLDB = versionInfo.group(3);
                    this.databaseMajorForNonPostgresSQLDB = Integer.parseInt(versionInfo.group(7));
                    this.databaseMinorForNonPostgresSQLDB = Integer.parseInt(versionInfo.group(8));
                    this.databaseSubminorForNonPostgresSQLDB = Integer.parseInt(versionInfo.group(9));
                }
                this.retrievedInfo = true;
            }
            catch (SQLException sQLException) {
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new PostgresDatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

