/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.ConnectionProperty;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;

public abstract class AbstractConnectionProperty<T>
implements ConnectionProperty<T> {
    private static final String EQUAL_STR = "=";
    protected static final Predicate<Properties> REQUIRED = properties -> true;
    protected static final Predicate<Properties> NOT_REQUIRED = properties -> false;
    protected static final Predicate<Properties> ALLOWED_ANY = properties -> true;
    protected static final Converter<String> STRING_CONVERTER = value -> value;
    protected static final Converter<Boolean> BOOLEAN_CONVERTER = value -> {
        String lowerCaseValue = value.toLowerCase(Locale.ENGLISH);
        if ("true".compareTo(lowerCaseValue) == 0) {
            return true;
        }
        if ("false".compareTo(lowerCaseValue) == 0) {
            return false;
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0050"));
    };
    protected static final Converter<URI> URI_CONVERTER = value -> {
        try {
            return new URI(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0051"), e);
        }
    };
    protected static final Converter<Integer> PORT_CONVERTER = value -> {
        int port;
        try {
            port = Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0052", value), e);
        }
        if ((port < 0 || port > 65535) && -1 != port) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0074", value));
        }
        return port;
    };
    protected static final Converter<Integer> POSITIVE_INTEGER_CONVERTER = value -> {
        int intValue;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0052", value), e);
        }
        if (intValue <= 0) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0074", value));
        }
        return intValue;
    };
    protected static final Converter<Integer> NON_NEGATIVE_INTEGER_CONVERTER = value -> {
        int intValue;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0052", value), e);
        }
        if (intValue < 0) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0011", value));
        }
        return intValue;
    };
    protected static final Converter<UnitValues> UNIT_VALUE_CONVERTER = value -> {
        if (UnitValues.E.getValue().compareTo(value) == 0) {
            return UnitValues.E;
        }
        if (UnitValues.M.getValue().compareTo(value) == 0) {
            return UnitValues.M;
        }
        if (UnitValues.S.getValue().compareTo(value) == 0) {
            return UnitValues.S;
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0053", value));
    };
    protected static final Converter<LanguageValues> LANGUAGE_VALUE_CONVERTER = value -> {
        if (LanguageValues.EN_US.getValue().compareTo(value) == 0) {
            return LanguageValues.EN_US;
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0054", value));
    };
    protected static final Converter<Path> PATH_CONVERTER = value -> {
        try {
            if (value.trim().isEmpty()) {
                throw new IllegalArgumentException(TWCMessageUtil.getMessage("0055", value));
            }
            File f = new File(value);
            if (f.exists() && f.isDirectory()) {
                return f.toPath();
            }
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0055", value));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0055", value, e));
        }
    };
    private final String key;
    private final String twcQueryParameterKey;
    private final Optional<String> defaultValue;
    private final Predicate<Properties> isRequired;
    private final Predicate<Properties> isAllowed;
    private final Converter<T> converter;

    protected AbstractConnectionProperty(String key, String queryParameterKey, Optional<String> defaultValue, Predicate<Properties> isRequired, Predicate<Properties> isAllowed, Converter<T> converter) {
        this.key = Objects.requireNonNull(key, TWCMessageUtil.getMessage("0007", "key")).toUpperCase();
        this.twcQueryParameterKey = Objects.requireNonNull(queryParameterKey, TWCMessageUtil.getMessage("0007", "queryParameter"));
        this.defaultValue = Objects.requireNonNull(defaultValue, TWCMessageUtil.getMessage("0007", "defaultValue"));
        this.isRequired = Objects.requireNonNull(isRequired, TWCMessageUtil.getMessage("0007", "isRequired"));
        this.isAllowed = Objects.requireNonNull(isAllowed, TWCMessageUtil.getMessage("0007", "isAllowed"));
        this.converter = Objects.requireNonNull(converter, TWCMessageUtil.getMessage("0007", "converter"));
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getQueryParameterKey() {
        return this.twcQueryParameterKey;
    }

    @Override
    public Optional<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public DriverPropertyInfo getDriverPropertyInfo(Properties mergedProperties) {
        String currentValue = mergedProperties.getProperty(this.key);
        DriverPropertyInfo result = new DriverPropertyInfo(this.key, currentValue);
        result.required = this.isRequired(mergedProperties);
        return result;
    }

    @Override
    public boolean isRequired(Properties properties) {
        return this.isRequired.test(properties);
    }

    @Override
    public boolean isAllowed(Properties properties) {
        return this.isAllowed.test(properties);
    }

    @Override
    public Optional<T> getValue(Properties properties) throws SQLException {
        String value = properties.getProperty(this.key);
        if (null == value) {
            if (this.isRequired(properties)) {
                throw new SQLException(String.format("Connection property '%s' is required.", this.key), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.REQUIRED_PROPERTY_NAME.getErrorCode());
            }
            return Optional.empty();
        }
        try {
            return Optional.of(this.converter.convert(value));
        }
        catch (RuntimeException e) {
            if (value.isEmpty()) {
                throw new SQLException(TWCMessageUtil.getMessage("0056", this.key), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.MISSING_PROPERTY_VALUE.getErrorCode(), e);
            }
            throw new SQLException(TWCMessageUtil.getMessage("0057", this.key, value), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.INVALID_PROPERTY_VALUE.getErrorCode(), e);
        }
    }

    @Override
    public void validate(Properties properties) throws SQLException {
        if (!this.isAllowed(properties)) {
            throw new SQLException(TWCMessageUtil.getMessage("0058", this.key, properties.getProperty(this.key)), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.INVALID_PROPERTY_VALUE.getErrorCode());
        }
        this.getValue(properties);
    }

    @Override
    public String getQueryParameterString(Properties properties) throws SQLException {
        if (this.getQueryParameterKey().isEmpty()) {
            throw new SQLException(TWCMessageUtil.getMessage("0059", this.key), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.PROPRERTY_CONVERSION_ERROR.getErrorCode());
        }
        Optional<T> optionalValue = this.getValue(properties);
        if (optionalValue.isPresent()) {
            return this.getQueryParameterKey() + EQUAL_STR + optionalValue.get().toString();
        }
        throw new SQLException(TWCMessageUtil.getMessage("0060", this.key), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.PROPRERTY_CONVERSION_ERROR.getErrorCode());
    }

    protected static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (SQLException e) {
                return false;
            }
        };
    }

    public static enum LanguageValues {
        EN_US("en-US");

        private String v;

        private LanguageValues(String value) {
            this.v = value;
        }

        public String getValue() {
            return this.v;
        }
    }

    public static enum UnitValues {
        E("e"),
        M("m"),
        S("s");

        private String v;

        private UnitValues(String value) {
            this.v = value;
        }

        public String getValue() {
            return this.v;
        }
    }

    public static enum SchemaValues {
        HISTORICAL("HISTORICAL"),
        FORECAST("FORECAST");

        private String v;

        private SchemaValues(String value) {
            this.v = value;
        }

        public String getValue() {
            return this.v;
        }
    }

    @FunctionalInterface
    static interface CheckedPredicate<T> {
        public boolean test(T var1) throws SQLException;
    }

    @FunctionalInterface
    static interface Converter<T> {
        public T convert(String var1);
    }
}

