/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.AbstractConnectionProperty;
import com.ibm.cognos.jdbc.twc.ConnectionProperty;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ConnectionProperties {
    private static final String EMPTY_STR = "";
    private static final String TWC_DEFAULT_AUTHORITY = "api.weather.com";
    private static final String TWC_DEFAULT_CATALOG = "V3";
    private static final String TWC_DEFAULT_SCHEMA = AbstractConnectionProperty.SchemaValues.HISTORICAL.getValue();
    private static final String TWC_DEFAULT_MAX_STATEMENTS = "15";
    private static final String TWC_DEFAULT_UNITS = AbstractConnectionProperty.UnitValues.S.getValue();
    private static final String TWC_DEFAULT_LANGUAGE = AbstractConnectionProperty.LanguageValues.EN_US.getValue();
    private static final String TWC_DEFAULT_CACHE_DIR = System.getProperty("java.io.tmpdir");
    private static final String TWC_DEFAULT_CACHE_TTL = String.valueOf(TimeUnit.HOURS.toSeconds(24L));
    private static final String TWC_DEFAULT_CACHE_SIZE = "100";
    private static final String TWC_DEFAULT_STRICT_MODE = "false";
    private static final String TWC_PROXY_HOST = "NOPROXY";
    private static final String TWC_PROXY_PORT = "-1";
    private static final String TWC_DEFAULT_QUERY_TIMEOUT = "60";
    private static final String TWC_DEFAULT_FILTER_METADATA = "false";
    public static final ConnectionProperty<String> AUTHORITY_PROPERTY = new AuthorityProperty();
    public static final ConnectionProperty<String> PASSWORD_PROPERTY = new PasswordProperty();
    public static final ConnectionProperty<String> CATALOG_PROPERTY = new CatalogProperty();
    public static final ConnectionProperty<String> SCHEMA_PROPERTY = new SchemaProperty();
    public static final ConnectionProperty<Integer> MAX_STATEMENTS_PROPERTY = new MaxStatementsProperty();
    public static final ConnectionProperty<AbstractConnectionProperty.UnitValues> UNITS_PROPERTY = new UnitsProperty();
    public static final ConnectionProperty<AbstractConnectionProperty.LanguageValues> LANGUAGE_PROPERTY = new LanguageProperty();
    public static final ConnectionProperty<Path> CACHE_DIR_PROPERTY = new CacheDirProperty();
    public static final ConnectionProperty<Integer> CACHE_TTL_PROPERTY = new CacheTTLProperty();
    public static final ConnectionProperty<Integer> CACHE_SIZE_PROPERTY = new CacheSizeProperty();
    public static final ConnectionProperty<Boolean> STRICT_MODE_PROPERTY = new StrictModeProperty();
    public static final ConnectionProperty<String> PROXY_HOST_PROPERTY = new ProxyHostProperty();
    public static final ConnectionProperty<Integer> PROXY_PORT_PROPERTY = new ProxyPortProperty();
    public static final ConnectionProperty<Integer> QUERY_TIMEOUT_PROPERTY = new QueryTimeoutProperty();
    public static final ConnectionProperty<Boolean> FILTER_METADATA_PROPERTY = new FilterMetadataProperty();
    private static final Set<ConnectionProperty<?>> ALL_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Arrays.asList(AUTHORITY_PROPERTY, PASSWORD_PROPERTY, CATALOG_PROPERTY, SCHEMA_PROPERTY, MAX_STATEMENTS_PROPERTY, UNITS_PROPERTY, LANGUAGE_PROPERTY, CACHE_DIR_PROPERTY, CACHE_TTL_PROPERTY, CACHE_SIZE_PROPERTY, STRICT_MODE_PROPERTY, PROXY_HOST_PROPERTY, PROXY_PORT_PROPERTY, QUERY_TIMEOUT_PROPERTY, FILTER_METADATA_PROPERTY)));
    private static final Map<String, ConnectionProperty<?>> PROPERTY_LOOKUP = Collections.unmodifiableMap(ALL_PROPERTIES.stream().collect(Collectors.toMap(ConnectionProperty::getKey, Function.identity())));
    private static final Map<String, String> DEFAULTS = Collections.unmodifiableMap(ALL_PROPERTIES.stream().filter(p -> p.getDefaultValue().isPresent()).collect(Collectors.toMap(ConnectionProperty::getKey, p -> p.getDefaultValue().get())));

    private ConnectionProperties() {
    }

    public static Set<ConnectionProperty<?>> getAllProperties() {
        return ALL_PROPERTIES;
    }

    public static Map<String, String> getDefaults() {
        return DEFAULTS;
    }

    public static ConnectionProperty<?> getConnectionProperty(String key) {
        return PROPERTY_LOOKUP.get(key);
    }

    private static class ProxyPortProperty
    extends AbstractConnectionProperty<Integer> {
        static final Predicate<Properties> ALLOWED = ProxyPortProperty.checkedPredicate(properties -> PROXY_PORT_PROPERTY.getValue((Properties)properties).isPresent());

        protected ProxyPortProperty() {
            super("PROXY_PORT", ConnectionProperties.EMPTY_STR, Optional.of(ConnectionProperties.TWC_PROXY_PORT), NOT_REQUIRED, ALLOWED, PORT_CONVERTER);
        }
    }

    private static class ProxyHostProperty
    extends AbstractConnectionProperty<String> {
        static final Predicate<Properties> ALLOWED = ProxyHostProperty.checkedPredicate(properties -> PROXY_HOST_PROPERTY.getValue((Properties)properties).isPresent());

        protected ProxyHostProperty() {
            super("PROXY_HOST", ConnectionProperties.EMPTY_STR, Optional.of(ConnectionProperties.TWC_PROXY_HOST), NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class FilterMetadataProperty
    extends AbstractConnectionProperty<Boolean> {
        static final Predicate<Properties> ALLOWED = FilterMetadataProperty.checkedPredicate(properties -> FILTER_METADATA_PROPERTY.getValue((Properties)properties).isPresent());

        protected FilterMetadataProperty() {
            super("FILTER_METADATA", ConnectionProperties.EMPTY_STR, Optional.of("false"), NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class StrictModeProperty
    extends AbstractConnectionProperty<Boolean> {
        static final Predicate<Properties> ALLOWED = StrictModeProperty.checkedPredicate(properties -> STRICT_MODE_PROPERTY.getValue((Properties)properties).isPresent());

        protected StrictModeProperty() {
            super("STRICT_MODE", ConnectionProperties.EMPTY_STR, Optional.of("false"), NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class QueryTimeoutProperty
    extends AbstractConnectionProperty<Integer> {
        static final Predicate<Properties> ALLOWED = QueryTimeoutProperty.checkedPredicate(properties -> QUERY_TIMEOUT_PROPERTY.getValue((Properties)properties).isPresent());

        protected QueryTimeoutProperty() {
            super("QUERY_TIMEOUT", ConnectionProperties.EMPTY_STR, Optional.of(ConnectionProperties.TWC_DEFAULT_QUERY_TIMEOUT), NOT_REQUIRED, ALLOWED, NON_NEGATIVE_INTEGER_CONVERTER);
        }
    }

    private static class CacheSizeProperty
    extends AbstractConnectionProperty<Integer> {
        static final Predicate<Properties> ALLOWED = CacheSizeProperty.checkedPredicate(properties -> CACHE_SIZE_PROPERTY.getValue((Properties)properties).isPresent());

        protected CacheSizeProperty() {
            super("CACHE_SIZE", ConnectionProperties.EMPTY_STR, Optional.of(ConnectionProperties.TWC_DEFAULT_CACHE_SIZE), NOT_REQUIRED, ALLOWED, NON_NEGATIVE_INTEGER_CONVERTER);
        }
    }

    private static class CacheTTLProperty
    extends AbstractConnectionProperty<Integer> {
        static final Predicate<Properties> ALLOWED = CacheTTLProperty.checkedPredicate(properties -> CACHE_TTL_PROPERTY.getValue((Properties)properties).isPresent());

        protected CacheTTLProperty() {
            super("CACHE_TTL", ConnectionProperties.EMPTY_STR, Optional.of(TWC_DEFAULT_CACHE_TTL), NOT_REQUIRED, ALLOWED, NON_NEGATIVE_INTEGER_CONVERTER);
        }
    }

    private static class CacheDirProperty
    extends AbstractConnectionProperty<Path> {
        static final Predicate<Properties> ALLOWED = CacheDirProperty.checkedPredicate(properties -> CACHE_DIR_PROPERTY.getValue((Properties)properties).isPresent());

        protected CacheDirProperty() {
            super("CACHE_DIR", ConnectionProperties.EMPTY_STR, Optional.of(TWC_DEFAULT_CACHE_DIR), NOT_REQUIRED, ALLOWED, PATH_CONVERTER);
        }
    }

    private static class LanguageProperty
    extends AbstractConnectionProperty<AbstractConnectionProperty.LanguageValues> {
        static final Predicate<Properties> ALLOWED = LanguageProperty.checkedPredicate(properties -> LANGUAGE_PROPERTY.getValue((Properties)properties).isPresent());

        protected LanguageProperty() {
            super("LANGUAGE", "language", Optional.of(TWC_DEFAULT_LANGUAGE), NOT_REQUIRED, ALLOWED, LANGUAGE_VALUE_CONVERTER);
        }
    }

    private static class UnitsProperty
    extends AbstractConnectionProperty<AbstractConnectionProperty.UnitValues> {
        static final Predicate<Properties> ALLOWED = UnitsProperty.checkedPredicate(properties -> UNITS_PROPERTY.getValue((Properties)properties).isPresent());

        protected UnitsProperty() {
            super("UNITS", "units", Optional.of(TWC_DEFAULT_UNITS), NOT_REQUIRED, ALLOWED, UNIT_VALUE_CONVERTER);
        }
    }

    private static class MaxStatementsProperty
    extends AbstractConnectionProperty<Integer> {
        static final Predicate<Properties> ALLOWED = MaxStatementsProperty.checkedPredicate(properties -> MAX_STATEMENTS_PROPERTY.getValue((Properties)properties).isPresent());

        protected MaxStatementsProperty() {
            super("MAX_STATEMENTS", ConnectionProperties.EMPTY_STR, Optional.of(ConnectionProperties.TWC_DEFAULT_MAX_STATEMENTS), NOT_REQUIRED, ALLOWED, POSITIVE_INTEGER_CONVERTER);
        }
    }

    private static class SchemaProperty
    extends AbstractConnectionProperty<String> {
        static final List<String> ALLOWED_VALUES = Collections.unmodifiableList(Arrays.asList(AbstractConnectionProperty.SchemaValues.HISTORICAL.getValue(), AbstractConnectionProperty.SchemaValues.FORECAST.getValue()));
        static final Predicate<Properties> ALLOWED = SchemaProperty.checkedPredicate(properties -> SCHEMA_PROPERTY.getValue((Properties)properties).isPresent() && ALLOWED_VALUES.contains(SCHEMA_PROPERTY.getValue((Properties)properties).get()));

        public SchemaProperty() {
            super("SCHEMA", ConnectionProperties.EMPTY_STR, Optional.of(TWC_DEFAULT_SCHEMA), NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class CatalogProperty
    extends AbstractConnectionProperty<String> {
        static final List<String> ALLOWED_VALUES = Collections.unmodifiableList(Collections.singletonList("V3"));
        static final Predicate<Properties> ALLOWED = CatalogProperty.checkedPredicate(properties -> CATALOG_PROPERTY.getValue((Properties)properties).isPresent() && ALLOWED_VALUES.contains(CATALOG_PROPERTY.getValue((Properties)properties).get()));

        public CatalogProperty() {
            super("CATALOG", ConnectionProperties.EMPTY_STR, Optional.of(ConnectionProperties.TWC_DEFAULT_CATALOG), NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class PasswordProperty
    extends AbstractConnectionProperty<String> {
        public PasswordProperty() {
            super("PASSWORD", "apiKey", Optional.empty(), REQUIRED, ALLOWED_ANY, STRING_CONVERTER);
        }
    }

    private static class AuthorityProperty
    extends AbstractConnectionProperty<String> {
        public AuthorityProperty() {
            super("AUTHORITY", ConnectionProperties.EMPTY_STR, Optional.of(ConnectionProperties.TWC_DEFAULT_AUTHORITY), NOT_REQUIRED, ALLOWED_ANY, STRING_CONVERTER);
        }
    }
}

