/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.HttpProcessor;
import com.ibm.cognos.jdbc.twc.QueryStatus;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.TWCResultSet;
import com.ibm.cognos.jdbc.twc.TWCResultSetMetaData;
import com.ibm.cognos.jdbc.twc.avro.AvroRowWalker;
import com.ibm.cognos.jdbc.twc.csv.CSVParser;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.metadata.generated.Table;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.client.CloseableHttpClient;
import com.ibm.cognos.jdbc.twc.org.apache.http.util.EntityUtils;
import com.ibm.cognos.jdbc.twc.org.slf4j.Logger;
import com.ibm.cognos.jdbc.twc.org.slf4j.LoggerFactory;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedColumn;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedTable;
import com.ibm.cognos.jdbc.twc.sqlparser.TWCSQLParserWrapper;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class HttpInMemoryProcessor
extends HttpProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpInMemoryProcessor.class);
    private static final String COMMA_STR = ",";
    private static final String LEFT_BRACKET_STR = "[";
    private static final String RIGHT_BRACKET_STR = "]";
    private static final String DOUBLE_QUOTE_STR = "\"";
    private static final Predicate<? super BoundedColumn> IS_NOT_LITERAL_COLUMN_LAMBDA = bc -> !bc.getColumnIdentifier().isLiteral();
    private static final Predicate<? super Column> IS_REMOTE_COLUMN_LAMBDA = c -> c.getValues() == null || c.getValues().isEmpty();
    private static final Supplier<TreeSet<Column>> COLUMN_TREE_SET_FACTORY_LAMBDA = () -> new TreeSet<Column>(Comparator.comparingInt(Column::getOrdinal));
    private final int numOfRows;
    private final List<Column> remoteColumns;
    private final Set<Column> projectedRemoteColumns;
    private final Set<Column> projectedLocalColumns;
    private final StringJoiner lines;
    private final CloseableHttpClient httpClient;

    HttpInMemoryProcessor(TWCSQLParserWrapper parser, CloseableHttpClient theHttpClient) {
        this.httpClient = theHttpClient;
        List currentTables = parser.getBoundedTables().values().stream().map(BoundedTable::getTable).collect(Collectors.toList());
        if (currentTables.isEmpty() || currentTables.size() > 2) {
            throw new IllegalStateException(TWCMessageUtil.getMessage("0086", 1, currentTables.stream().map(Table::getName).collect(Collectors.joining(COMMA_STR, LEFT_BRACKET_STR, RIGHT_BRACKET_STR))));
        }
        Table currentTable = (Table)currentTables.get(0);
        this.numOfRows = currentTable.getRelativePaths().size();
        this.remoteColumns = currentTable.getColumns().stream().filter(IS_REMOTE_COLUMN_LAMBDA).collect(Collectors.toList());
        this.remoteColumns.sort(Comparator.comparingInt(Column::getOrdinal));
        this.projectedRemoteColumns = parser.getBoundedColumns().stream().filter(IS_NOT_LITERAL_COLUMN_LAMBDA).map(BoundedColumn::getColumn).filter(IS_REMOTE_COLUMN_LAMBDA).collect(Collectors.toCollection(COLUMN_TREE_SET_FACTORY_LAMBDA));
        this.projectedLocalColumns = parser.getBoundedColumns().stream().filter(IS_NOT_LITERAL_COLUMN_LAMBDA).map(BoundedColumn::getColumn).filter(IS_REMOTE_COLUMN_LAMBDA.negate()).collect(Collectors.toCollection(COLUMN_TREE_SET_FACTORY_LAMBDA));
        StringJoiner sj = new StringJoiner(COMMA_STR);
        if (!this.projectedRemoteColumns.isEmpty()) {
            for (Column remoteColumn : this.remoteColumns) {
                sj.add(remoteColumn.getName());
            }
        }
        for (Column localColumn : this.projectedLocalColumns) {
            sj.add(localColumn.getName());
        }
        String header = sj.toString();
        this.lines = new StringJoiner(System.lineSeparator());
        this.lines.add(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TWCResultSet execute(String connectionId, Statement statement, QueryStatus status, TWCConnectionString connStr, TWCSQLParserWrapper parser) throws Exception {
        boolean[] requiresPagination = new boolean[]{false};
        for (int i = 0; i < this.numOfRows; ++i) {
            StringJoiner line = new StringJoiner(COMMA_STR);
            if (!this.projectedRemoteColumns.isEmpty()) {
                String uriSTR = parser.getURIs().get(i);
                URI uri = HttpProcessor.constructURI(uriSTR, connStr);
                HttpProcessor.ResponseEntityStruct response = null;
                try {
                    LOGGER.info("QueryId: {} - Accessing '{}' for results.", (Object)status.getRequestId(), (Object)uriSTR);
                    response = this.executeRequest(this.httpClient, uri, requiresPagination, uriSTR, false);
                    String responseAsAString = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                    if (this.remoteColumns.size() == 1) {
                        line.add(HttpInMemoryProcessor.cleanseCSVValue(responseAsAString));
                    } else {
                        String[] splittedResponse = responseAsAString.split(COMMA_STR);
                        for (int counter = 0; counter < splittedResponse.length && counter < this.remoteColumns.size(); ++counter) {
                            line.add(HttpInMemoryProcessor.cleanseCSVValue(splittedResponse[counter]));
                        }
                        if (splittedResponse.length < this.remoteColumns.size()) {
                            line.add("");
                        }
                    }
                }
                finally {
                    if (null != response) {
                        response.closeQuietly();
                    }
                }
            }
            if (!this.projectedLocalColumns.isEmpty()) {
                for (Column projectedLocalColumn : this.projectedLocalColumns) {
                    List<String> values = projectedLocalColumn.getValues();
                    if (i < values.size()) {
                        line.add(HttpInMemoryProcessor.cleanseCSVValue(projectedLocalColumn.getValues().get(i)));
                        continue;
                    }
                    line.add("");
                }
            }
            this.lines.add(line.toString());
        }
        String csvPayload = this.lines.toString();
        ArrayList<Column> allProjectedNonLiteralColumns = new ArrayList<Column>();
        allProjectedNonLiteralColumns.addAll(this.projectedRemoteColumns);
        allProjectedNonLiteralColumns.addAll(this.projectedLocalColumns);
        CSVSchema csvSchema = CSVParser.toCSVSchema(allProjectedNonLiteralColumns);
        CSVParser csvParser = new CSVParser(csvSchema, null, null, false);
        ByteArrayInputStream bais = new ByteArrayInputStream(csvPayload.getBytes(StandardCharsets.UTF_8));
        csvParser.parse(bais, StandardCharsets.UTF_8.toString());
        List<Object[]> rawResults = csvParser.getRows();
        LinkedList<List<Object>> results = new LinkedList<List<Object>>();
        for (Object[] rawResult : rawResults) {
            results.add(Arrays.asList(rawResult));
        }
        return this.constructResultSet(connectionId, status.getRequestId(), statement, csvSchema, parser, results);
    }

    private TWCResultSet constructResultSet(String connId, String requestId, Statement statement, CSVSchema csvSchema, TWCSQLParserWrapper parser, List<List<Object>> results) throws SQLException {
        TWCResultSet twcRS;
        boolean errorThrown = false;
        LinkedList<String> avroIds = new LinkedList<String>();
        AvroRowWalker rowWalker = null;
        try {
            List<BoundedColumn> boundedColumns = parser.getBoundedColumns();
            TWCResultSetMetaData rsMeta = TWCResultSetMetaData.fromBoundedColumns(parser.getCatalog(), parser.getSchema(), boundedColumns);
            int[] projectedColsMapping = csvSchema.boundedColumnsMapping(boundedColumns);
            Map<String, Integer> csvColsMapping = csvSchema.csvColumnNames2RowIdxs();
            if (results.isEmpty()) {
                List emptyResult = Collections.emptyList();
                twcRS = new TWCResultSet(requestId, connId, rsMeta, emptyResult.iterator(), statement, rowWalker, parser, projectedColsMapping, csvColsMapping, parser.getProjectedLiterals(), parser.getProjectedLiteralsOrdinalPositions(), null, avroIds);
            } else {
                rowWalker = new AvroRowWalker(avroIds, csvSchema);
                twcRS = new TWCResultSet(requestId, connId, rsMeta, results.iterator(), statement, rowWalker, parser, projectedColsMapping, csvColsMapping, parser.getProjectedLiterals(), parser.getProjectedLiteralsOrdinalPositions(), null, avroIds);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e) {
            errorThrown = true;
            throw new SQLException(TWCMessageUtil.getMessage("0046", "Failed to construct avro-row-walker."), e);
        }
        finally {
            if (errorThrown && null != rowWalker) {
                try {
                    rowWalker.close();
                }
                catch (Exception exception) {}
            }
        }
        return twcRS;
    }

    static String cleanseCSVValue(String input) {
        return DOUBLE_QUOTE_STR + input.replaceAll(DOUBLE_QUOTE_STR, "\"\"") + DOUBLE_QUOTE_STR;
    }
}

