/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.QueryProcessor;
import com.ibm.cognos.jdbc.twc.QueryStatus;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.TWCResultSet;
import com.ibm.cognos.jdbc.twc.TWCResultSetMetaData;
import com.ibm.cognos.jdbc.twc.avro.AvroRowWalker;
import com.ibm.cognos.jdbc.twc.csv.CSVParser;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.metadata.generated.Table;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedColumn;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedTable;
import com.ibm.cognos.jdbc.twc.sqlparser.TWCSQLParserWrapper;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class LocalAvroProcessor
implements QueryProcessor {
    private static final String COMMA_STR = ",";
    private static final String LEFT_BRACKET_STR = "[";
    private static final String RIGHT_BRACKET_STR = "]";

    LocalAvroProcessor() {
    }

    @Override
    public TWCResultSet execute(String connectionId, Statement statement, QueryStatus status, TWCConnectionString connStr, TWCSQLParserWrapper parser) throws Exception {
        List currentTables = parser.getBoundedTables().values().stream().map(BoundedTable::getTable).collect(Collectors.toList());
        if (currentTables.isEmpty() || currentTables.size() > 2) {
            throw new IllegalStateException(TWCMessageUtil.getMessage("0086", 1, currentTables.stream().map(Table::getName).collect(Collectors.joining(COMMA_STR, LEFT_BRACKET_STR, RIGHT_BRACKET_STR))));
        }
        Table currentTable = (Table)currentTables.get(0);
        ArrayList<Column> columns = new ArrayList<Column>(currentTable.getColumns());
        CSVSchema csvSchema = CSVParser.toCSVSchema(columns);
        return this.constructResultSet(connectionId, status.getRequestId(), statement, csvSchema, parser);
    }

    private TWCResultSet constructResultSet(String connId, String requestId, Statement statement, CSVSchema csvSchema, TWCSQLParserWrapper parser) throws SQLException {
        TWCResultSet twcRS;
        boolean errorThrown = false;
        LinkedList<String> avroIds = new LinkedList<String>();
        AvroRowWalker rowWalker = null;
        try {
            List<BoundedColumn> boundedColumns = parser.getBoundedColumns();
            TWCResultSetMetaData rsMeta = TWCResultSetMetaData.fromBoundedColumns(parser.getCatalog(), parser.getSchema(), boundedColumns);
            int[] projectedColsMapping = csvSchema.boundedColumnsMapping(boundedColumns);
            Map<String, Integer> csvColsMapping = csvSchema.csvColumnNames2RowIdxs();
            rowWalker = new AvroRowWalker(parser.getURIs(), csvSchema);
            twcRS = new TWCResultSet(requestId, connId, rsMeta, rowWalker.iterator(), statement, rowWalker, parser, projectedColsMapping, csvColsMapping, parser.getProjectedLiterals(), parser.getProjectedLiteralsOrdinalPositions(), null, avroIds);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e) {
            errorThrown = true;
            throw new SQLException(TWCMessageUtil.getMessage("0046", "Failed to construct avro-row-walker."), e);
        }
        finally {
            if (errorThrown && null != rowWalker) {
                try {
                    rowWalker.close();
                }
                catch (Exception exception) {}
            }
        }
        return twcRS;
    }
}

