/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.avro;

import com.ibm.cognos.jdbc.twc.avro.AvroHelper;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.csv.CSVSchemaField;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.apache.avro.Schema;
import com.ibm.cognos.jdbc.twc.org.apache.avro.file.CodecFactory;
import com.ibm.cognos.jdbc.twc.org.apache.avro.file.DataFileWriter;
import com.ibm.cognos.jdbc.twc.org.apache.avro.generic.GenericData;
import com.ibm.cognos.jdbc.twc.org.apache.avro.generic.GenericRecord;
import com.ibm.cognos.jdbc.twc.util.RowWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.util.List;

public class AvroRowWriter
implements RowWriter,
TWCMessageKeys {
    private final List<CSVSchemaField> csvSchemaFields;
    private final Schema avroSchema;
    private final DataFileWriter<GenericRecord> writer;
    private boolean closed = false;

    public AvroRowWriter(CSVSchema schema, OutputStream out) throws IOException {
        this.avroSchema = AvroHelper.toAvroSchema(schema);
        this.csvSchemaFields = schema.getFields();
        this.writer = new DataFileWriter(GenericData.get().createDatumWriter(this.avroSchema)).setCodec(CodecFactory.snappyCodec()).create(this.avroSchema, out);
    }

    @Override
    public void writeArray(Object[] source) throws IOException {
        if (source.length != this.csvSchemaFields.size()) {
            throw new IllegalArgumentException("source.length != csvSchema.getFieldsSize()");
        }
        this.expectNotClosed();
        GenericData.Record record = new GenericData.Record(this.avroSchema);
        int index = 0;
        for (CSVSchemaField field : this.csvSchemaFields) {
            if (source[index] == null) {
                if (!field.isNullable()) {
                    throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", field.getName()));
                }
                record.put(field.getName(), null);
            } else {
                switch (field.getDataType()) {
                    case DATE: {
                        record.put(field.getName(), (Object)AvroHelper.encodeDate((Date)source[index]));
                        break;
                    }
                    default: {
                        record.put(field.getName(), source[index]);
                    }
                }
            }
            ++index;
        }
        this.writer.append(record);
    }

    @Override
    public void flush() throws IOException {
        this.expectNotClosed();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.writer.close();
        }
    }

    private void expectNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(TWCMessageUtil.getMessage("0069"));
        }
    }
}

