/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.jackson.databind.module;

import com.ibm.cognos.jdbc.twc.jackson.databind.BeanDescription;
import com.ibm.cognos.jdbc.twc.jackson.databind.DeserializationConfig;
import com.ibm.cognos.jdbc.twc.jackson.databind.JavaType;
import com.ibm.cognos.jdbc.twc.jackson.databind.JsonDeserializer;
import com.ibm.cognos.jdbc.twc.jackson.databind.JsonMappingException;
import com.ibm.cognos.jdbc.twc.jackson.databind.JsonNode;
import com.ibm.cognos.jdbc.twc.jackson.databind.KeyDeserializer;
import com.ibm.cognos.jdbc.twc.jackson.databind.deser.Deserializers;
import com.ibm.cognos.jdbc.twc.jackson.databind.jsontype.TypeDeserializer;
import com.ibm.cognos.jdbc.twc.jackson.databind.type.ArrayType;
import com.ibm.cognos.jdbc.twc.jackson.databind.type.ClassKey;
import com.ibm.cognos.jdbc.twc.jackson.databind.type.CollectionLikeType;
import com.ibm.cognos.jdbc.twc.jackson.databind.type.CollectionType;
import com.ibm.cognos.jdbc.twc.jackson.databind.type.MapLikeType;
import com.ibm.cognos.jdbc.twc.jackson.databind.type.MapType;
import com.ibm.cognos.jdbc.twc.jackson.databind.type.ReferenceType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleDeserializers
implements Deserializers,
Serializable {
    private static final long serialVersionUID = 1L;
    protected HashMap<ClassKey, JsonDeserializer<?>> _classMappings = null;
    protected boolean _hasEnumDeserializer = false;

    public SimpleDeserializers() {
    }

    public SimpleDeserializers(Map<Class<?>, JsonDeserializer<?>> desers) {
        this.addDeserializers(desers);
    }

    public <T> void addDeserializer(Class<T> forClass, JsonDeserializer<? extends T> deser) {
        ClassKey key = new ClassKey(forClass);
        if (this._classMappings == null) {
            this._classMappings = new HashMap();
        }
        this._classMappings.put(key, deser);
        if (forClass == Enum.class) {
            this._hasEnumDeserializer = true;
        }
    }

    public void addDeserializers(Map<Class<?>, JsonDeserializer<?>> desers) {
        for (Map.Entry<Class<?>, JsonDeserializer<?>> entry : desers.entrySet()) {
            Class<?> cls = entry.getKey();
            JsonDeserializer<?> deser = entry.getValue();
            this.addDeserializer(cls, deser);
        }
    }

    @Override
    public JsonDeserializer<?> findArrayDeserializer(ArrayType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        JsonDeserializer<?> deser = this._classMappings.get(new ClassKey(type));
        if (deser == null && this._hasEnumDeserializer && type.isEnum()) {
            deser = this._classMappings.get(new ClassKey(Enum.class));
        }
        return deser;
    }

    @Override
    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> nodeType, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(nodeType));
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        return this._find(refType);
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    private final JsonDeserializer<?> _find(JavaType type) {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(type.getRawClass()));
    }
}

