/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.org.apache.commons.compress.compressors.xz;

import com.ibm.cognos.jdbc.twc.org.apache.commons.compress.compressors.CompressorInputStream;
import com.ibm.cognos.jdbc.twc.org.tukaani.xz.SingleXZInputStream;
import com.ibm.cognos.jdbc.twc.org.tukaani.xz.XZ;
import com.ibm.cognos.jdbc.twc.org.tukaani.xz.XZInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XZCompressorInputStream
extends CompressorInputStream {
    private final InputStream in;

    public static boolean matches(byte[] signature, int length) {
        if (length < XZ.HEADER_MAGIC.length) {
            return false;
        }
        for (int i = 0; i < XZ.HEADER_MAGIC.length; ++i) {
            if (signature[i] == XZ.HEADER_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    public XZCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated) throws IOException {
        this.in = decompressConcatenated ? new XZInputStream(inputStream) : new SingleXZInputStream(inputStream);
    }

    public int read() throws IOException {
        int ret = this.in.read();
        this.count(ret == -1 ? -1 : 1);
        return ret;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        this.count(ret);
        return ret;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

