/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.generated.TWCSQLLexer;
import java.util.Objects;

abstract class AbstractFilterExpression
implements FilterExpression,
TWCMessageKeys {
    static final String OPEN_PARENTHESIS_STR;
    static final String CLOSE_PARENTHESIS_STR;
    static final String AND_STR;
    static final String OR_STR;
    static final String NOT_STR;
    static final String COMMA_STR;
    private final FilterExpression.Operator operator;
    private final ParseTree ctx;

    protected AbstractFilterExpression(FilterExpression.Operator op, ParseTree context) {
        Objects.requireNonNull(context, TWCMessageUtil.getMessage("0007", "context"));
        this.operator = op;
        this.ctx = context;
    }

    @Override
    public FilterExpression.Operator getFilterOperator() {
        return this.operator;
    }

    @Override
    public boolean isUnary() {
        return FilterExpression.FilterExpressionType.UNARY.equals((Object)this.getFilterExpressionType());
    }

    @Override
    public ParseTree getContext() {
        return this.ctx;
    }

    @Override
    public boolean accept(FilterConditionEvaluator evaluator) {
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0080"));
    }

    static {
        String openParenthesisStr = TWCSQLLexer.VOCABULARY.getLiteralName(9);
        OPEN_PARENTHESIS_STR = openParenthesisStr.substring(1, openParenthesisStr.length() - 1);
        String closeParenthesisStr = TWCSQLLexer.VOCABULARY.getLiteralName(10);
        CLOSE_PARENTHESIS_STR = closeParenthesisStr.substring(1, closeParenthesisStr.length() - 1);
        AND_STR = TWCSQLLexer.VOCABULARY.getSymbolicName(18);
        OR_STR = TWCSQLLexer.VOCABULARY.getSymbolicName(19);
        NOT_STR = TWCSQLLexer.VOCABULARY.getSymbolicName(20);
        String commaStr = TWCSQLLexer.VOCABULARY.getLiteralName(4);
        COMMA_STR = commaStr.substring(1, commaStr.length() - 1);
    }
}

