/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

class DateLiteralValue
extends AbstractLiteralValue
implements TWCMessageKeys {
    static final LocalDate MIN_SQL_ISO_DATE = LocalDate.of(1, 1, 1);
    static final LocalDate MAX_SQL_ISO_DATE = LocalDate.of(9999, 12, 31);
    private final LocalDate value;

    private DateLiteralValue(String literal, ParseTree ctx) {
        super(literal, Column.Datatype.DATE, ctx);
        this.value = LocalDate.parse(literal, DateTimeFormatter.ISO_LOCAL_DATE);
        if (this.value.isBefore(MIN_SQL_ISO_DATE) || this.value.isAfter(MAX_SQL_ISO_DATE)) {
            throw new DateTimeParseException(TWCMessageUtil.getMessage("0075", this.value, MIN_SQL_ISO_DATE, MAX_SQL_ISO_DATE), literal, 0);
        }
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof DateLiteralValue) {
            return this.value.isEqual(((DateLiteralValue)entity).getDateValue());
        }
        return false;
    }

    @Override
    public int compareTo(LiteralValue o) {
        if (o instanceof DateLiteralValue) {
            LocalDate v2;
            DateLiteralValue literal = (DateLiteralValue)o;
            LocalDate v1 = this.getDateValue();
            if (v1.isBefore(v2 = literal.getDateValue())) {
                return -1;
            }
            if (v1.isAfter(v2)) {
                return 1;
            }
            return 0;
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0026", o));
    }

    LocalDate getDateValue() {
        return this.value;
    }

    static class Builder {
        private String aLiteralValue;
        private ParseTree aCtx;

        Builder() {
        }

        Builder setLiteralValue(String literal) {
            this.aLiteralValue = literal;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        DateLiteralValue build() {
            return new DateLiteralValue(this.aLiteralValue, this.aCtx);
        }
    }
}

