/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;

public class DoubleLiteralValue
extends AbstractLiteralValue
implements TWCMessageKeys {
    static final double EQUALITY_THRESHOLD = Math.pow(10.0, -9.0);
    private final double value;

    private DoubleLiteralValue(String literal, ParseTree ctx) {
        super(literal, Column.Datatype.FLOAT, ctx);
        this.value = Double.parseDouble(literal);
    }

    @Override
    public boolean isEquivalent(Entity literal) {
        if (literal instanceof DoubleLiteralValue) {
            return Math.abs(this.value - ((DoubleLiteralValue)literal).getDoubleValue()) <= EQUALITY_THRESHOLD;
        }
        return false;
    }

    @Override
    public int compareTo(LiteralValue o) {
        if (o instanceof DoubleLiteralValue) {
            DoubleLiteralValue literal = (DoubleLiteralValue)o;
            double v1 = this.getDoubleValue();
            double v2 = literal.getDoubleValue();
            return Double.compare(v1, v2);
        }
        throw new IllegalArgumentException(TWCMessageUtil.getMessage("0067", o));
    }

    double getDoubleValue() {
        return this.value;
    }

    static class Builder {
        private String aLiteralValue;
        private ParseTree aCtx;

        Builder() {
        }

        Builder setLiteralValue(String literal) {
            this.aLiteralValue = literal;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        DoubleLiteralValue build() {
            return new DoubleLiteralValue(this.aLiteralValue, this.aCtx);
        }
    }
}

