/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedFilterIdentifier;
import com.ibm.cognos.jdbc.twc.sqlparser.ValuesInterval;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

class FilterIdentifierValuesResolver
implements TWCMessageKeys {
    private final BoundedFilterIdentifier boundedFilter;
    private final boolean isStrict;
    private boolean contradicts;
    private boolean representsContradiction;
    private Set<ValuesInterval> intervals = new TreeSet<ValuesInterval>();

    FilterIdentifierValuesResolver(BoundedFilterIdentifier theIdentifier, boolean strictMatch, boolean isContradictory, boolean propagatesContradiction) {
        Objects.requireNonNull(theIdentifier, TWCMessageUtil.getMessage("0007", "theIdentifier"));
        this.boundedFilter = theIdentifier;
        this.isStrict = strictMatch;
        this.contradicts = isContradictory;
        this.representsContradiction = propagatesContradiction;
    }

    BoundedFilterIdentifier getFilterIdentifier() {
        return this.boundedFilter;
    }

    boolean strictlyMatchFilterIdentifiers() {
        return this.isStrict;
    }

    boolean isContradictory() {
        return this.contradicts;
    }

    boolean representsContradiction() {
        return this.representsContradiction;
    }

    void setRepresentingContradiction() {
        this.representsContradiction = true;
    }

    Set<ValuesInterval> getIntervals() {
        return this.intervals;
    }

    void setIntervals(Set<ValuesInterval> intervalSet) {
        this.intervals = intervalSet;
    }

    void setContradictory(boolean value) {
        this.contradicts = value;
    }

    private void mergeIntervalsImplementation() {
        if (this.intervals.size() < 2) {
            return;
        }
        LinkedList<ValuesInterval> collidingIntervals = new LinkedList<ValuesInterval>();
        LinkedList<ValuesInterval> mergedIntervals = new LinkedList<ValuesInterval>();
        Iterator<ValuesInterval> it = this.intervals.iterator();
        ValuesInterval mergedInterval = it.next();
        while (it.hasNext()) {
            ValuesInterval currentInterval = it.next();
            if (mergedInterval.includes(currentInterval)) {
                collidingIntervals.add(currentInterval);
                continue;
            }
            if (mergedInterval.collides(currentInterval)) {
                mergedInterval.setEnd(currentInterval.getEnd());
                mergedInterval.setEndBounded(currentInterval.isEndBounded());
                collidingIntervals.add(currentInterval);
                continue;
            }
            mergedIntervals.add(mergedInterval);
            mergedInterval = currentInterval;
        }
        this.intervals.removeAll(collidingIntervals);
        this.intervals.addAll(mergedIntervals);
    }

    void mergeIntervals(Set<ValuesInterval> intervalSet) {
        this.intervals.addAll(intervalSet);
        this.mergeIntervalsImplementation();
    }

    void mergeInterval(ValuesInterval theInterval) {
        this.intervals.add(theInterval);
        this.mergeIntervalsImplementation();
    }

    void collapseIntervals(Set<ValuesInterval> intervalSet) {
        LinkedList<ValuesInterval> newIntervals = new LinkedList<ValuesInterval>();
        LinkedList<ValuesInterval> intervalsToBeRemoved = new LinkedList<ValuesInterval>();
        for (ValuesInterval interval : this.intervals) {
            boolean notCollidingWithAnyProvided = true;
            for (ValuesInterval providedInterval : intervalSet) {
                if (!interval.collides(providedInterval)) continue;
                notCollidingWithAnyProvided = false;
                ValuesInterval collapsedInterval = ValuesInterval.collapseIntervals(providedInterval, interval);
                newIntervals.add(collapsedInterval);
                intervalsToBeRemoved.add(interval);
            }
            if (!notCollidingWithAnyProvided) continue;
            intervalsToBeRemoved.add(interval);
        }
        this.intervals.removeAll(intervalsToBeRemoved);
        this.intervals.addAll(newIntervals);
        this.mergeIntervalsImplementation();
    }

    void reverseIntervals() {
        Iterator<ValuesInterval> it = this.intervals.iterator();
        LinkedList<ValuesInterval> newIntervals = new LinkedList<ValuesInterval>();
        ValuesInterval previous = null;
        int size = this.intervals.size();
        int counter = 0;
        while (it.hasNext()) {
            ValuesInterval newInterval;
            ValuesInterval current = it.next();
            if (counter == 0 && null != current.getBegin()) {
                newInterval = new ValuesInterval(null, current.getBegin(), false, !current.isBeginBounded());
                newIntervals.add(newInterval);
            }
            if (counter == size - 1 && null != current.getEnd()) {
                newInterval = new ValuesInterval(current.getEnd(), null, !current.isEndBounded(), false);
                newIntervals.add(newInterval);
            }
            if (null != previous) {
                newInterval = new ValuesInterval(previous.getEnd(), current.getBegin(), !previous.isEndBounded(), !current.isBeginBounded());
                newIntervals.add(newInterval);
            }
            previous = current;
            ++counter;
        }
        if (counter == 0) {
            newIntervals.add(new ValuesInterval(null, null, false, false));
        }
        this.intervals.clear();
        this.intervals.addAll(newIntervals);
        this.mergeIntervalsImplementation();
    }

    void clearAllIntervals() {
        this.intervals.clear();
    }

    boolean containsOnlyClosedSingularPointsAsIntervals(boolean allowEmptyList) {
        if (this.intervals.isEmpty()) {
            return allowEmptyList;
        }
        int counter = 0;
        Iterator<ValuesInterval> it = this.intervals.iterator();
        while (it.hasNext() && ValuesInterval.isClosedSingularPoint(it.next())) {
            ++counter;
        }
        return counter == this.intervals.size();
    }
}

